/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.lang.reflect.Method;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.core.NativeType;
import net.covers1624.curl4j.core.Pointer;
import net.covers1624.curl4j.core.Reflect;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class Callback
implements AutoCloseable {
    protected static final long ffi_type_pointer = Callback.ffi_type_pointer();
    protected static final long ffi_type_int = Callback.ffi_type_int();
    protected static final long ffi_type_long = Callback.ffi_type_long();
    private static final long builtin_callback = Callback.ffi_callback(Reflect.getDeclaredMethod(Callback.class, "ffi_callback", Long.TYPE, Long.TYPE));
    private final long cif;
    private final long callback;
    private final CallbackInterface delegate;
    private CallbackExceptionHandler exceptionHandler = CallbackExceptionHandler.DEFAULT;
    private long closure = 0L;
    private long delegateRef = 0L;
    private long code = 0L;

    protected Callback(long cif, @Nullable CallbackInterface delegate) {
        this(cif, builtin_callback, delegate);
    }

    protected Callback(long cif, long callback, @Nullable CallbackInterface delegate) {
        this.cif = cif;
        this.callback = callback;
        if (delegate == null) {
            if (!(this instanceof CallbackInterface)) {
                throw new IllegalArgumentException("When delegate is null, expected this object to be a CallbackInterface");
            }
            this.delegate = (CallbackInterface)((Object)this);
        } else {
            this.delegate = delegate;
        }
    }

    public final long getFunctionAddress() {
        if (this.closure == 0L) {
            try (Memory.Stack stack = Memory.pushStack();){
                Pointer codePtr = stack.mallocPointer();
                this.closure = Callback.ffi_closure_alloc(codePtr.address);
                if (this.closure == 0L) {
                    throw new OutOfMemoryError("Unable to alloc ffi closure");
                }
                this.code = codePtr.readAddress();
            }
            this.delegateRef = this.callback == builtin_callback ? Memory.newGlobalRef(this) : Memory.newGlobalRef(this.delegate);
            int ret = Callback.ffi_prep_closure_loc(this.closure, this.cif, this.callback, this.delegateRef, this.code);
            if (ret != 0) {
                this.close();
                throw new RuntimeException("ffi_prep_closure_loc failed. Code: " + ret);
            }
        }
        return this.code;
    }

    public final void setExceptionHandler(CallbackExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    @MustBeInvokedByOverriders
    public void close() {
        if (this.closure != 0L) {
            Callback.ffi_closure_free(this.closure);
            this.closure = 0L;
            this.code = 0L;
            Memory.deleteGlobalRef(this.delegateRef);
            this.delegateRef = 0L;
        }
        if (this.delegate != this) {
            try {
                this.delegate.close();
            }
            catch (Throwable ex) {
                Callback.throwUnchecked(ex);
            }
        }
    }

    private static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw t;
    }

    private static native long ffi_type_pointer();

    private static native long ffi_type_int();

    private static native long ffi_type_long();

    private static native long ffi_cif_alloc();

    protected static long ffi_prep_cif(long rtype, long ... atypes) {
        long cif = Callback.ffi_cif_alloc();
        if (cif == 0L) {
            throw new OutOfMemoryError();
        }
        int ret = Callback.ffi_prep_cif(cif, rtype, atypes);
        if (ret != 0) {
            Callback.ffi_cif_free(cif);
            throw new IllegalStateException("ffi_prep_cif returned code: " + ret);
        }
        return cif;
    }

    protected static native void ffi_cif_free(long var0);

    private static native int ffi_prep_cif(long var0, long var2, long ... var4);

    private static native long ffi_closure_alloc(long var0);

    private static native int ffi_prep_closure_loc(long var0, long var2, long var4, long var6, long var8);

    private static native void ffi_closure_free(long var0);

    private static native long ffi_callback(Method var0);

    private void ffi_callback(long ret, long args) throws Throwable {
        assert (this.delegate != null);
        try {
            this.delegate.invoke(ret, args);
        }
        catch (Throwable ex) {
            this.exceptionHandler.onException(ex);
        }
    }

    public static interface CallbackExceptionHandler {
        public static final CallbackExceptionHandler DEFAULT = ex -> {
            System.err.println("[curl4j] Exception thrown inside callback, this will silently be ignored.");
            ex.printStackTrace(System.err);
        };
        public static final CallbackExceptionHandler RETHROW = ex -> {
            throw ex;
        };

        public void onException(Throwable var1) throws Throwable;
    }

    public static interface CallbackInterface
    extends AutoCloseable {
        default public void invoke(@NativeType(value="void *") long ret, @NativeType(value="void **") long args) throws Throwable {
            throw new UnsupportedOperationException("Callback must override this function to use the built-in callback.");
        }

        @Override
        default public void close() throws Exception {
        }
    }
}

