/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.covers1624.curl4j.core.Architecture;
import net.covers1624.curl4j.core.LibC;
import net.covers1624.curl4j.core.Library;
import net.covers1624.curl4j.core.OperatingSystem;

public class LibraryLoader {
    private static final String LIB_PATH = System.getProperty("net.covers1624.curl4j.lib_path");
    private static final boolean NO_EMBEDDED = Boolean.getBoolean("net.covers1624.curl4j.no_embedded");

    public static void initialize() {
    }

    public static Library loadLibrary(String libName) throws UnsatisfiedLinkError {
        if (Paths.get(libName, new String[0]).isAbsolute()) {
            return LibraryLoader.loadLib(libName);
        }
        for (String libPath : LibraryLoader.getLibPaths(libName)) {
            Path path;
            if (LIB_PATH == null || !Files.exists(path = Paths.get(LIB_PATH, libPath), new LinkOption[0])) continue;
            return LibraryLoader.loadLib(path.toAbsolutePath().toString());
        }
        if (!NO_EMBEDDED) {
            for (String libPath : LibraryLoader.getLibPaths(libName)) {
                URL url = LibraryLoader.class.getResource("/META-INF/natives/" + libPath);
                if (url == null) continue;
                Path path = LibraryLoader.getAsAbsolutePath(url);
                if (path == null) {
                    path = LibraryLoader.extract(url, libName);
                }
                return LibraryLoader.loadLib(path.toAbsolutePath().toString());
            }
        }
        return LibraryLoader.loadLib(System.mapLibraryName(libName));
    }

    private static Library loadLib(String libName) {
        switch (OperatingSystem.CURRENT) {
            case WINDOWS: {
                return new Library.WindowsLibrary(libName);
            }
            case LINUX: {
                return new Library.LinuxLibrary(libName);
            }
            case MACOS: {
                return new Library.MacosLibrary(libName);
            }
            case FREEBSD: {
                break;
            }
        }
        throw new UnsupportedOperationException("Unknown/unsupported Operating System. " + (Object)((Object)OperatingSystem.CURRENT));
    }

    public static void loadJNILibrary(String libName) throws UnsatisfiedLinkError {
        if (Paths.get(libName, new String[0]).isAbsolute()) {
            System.load(libName);
            return;
        }
        for (String libPath : LibraryLoader.getLibPaths(libName)) {
            Path path;
            if (LIB_PATH == null || !Files.exists(path = Paths.get(LIB_PATH, libPath), new LinkOption[0])) continue;
            System.load(path.toAbsolutePath().toString());
            return;
        }
        if (!NO_EMBEDDED) {
            for (String libPath : LibraryLoader.getLibPaths(libName)) {
                URL url = LibraryLoader.class.getResource("/META-INF/natives/" + libPath);
                if (url == null) continue;
                Path path = LibraryLoader.getAsAbsolutePath(url);
                if (path == null) {
                    path = LibraryLoader.extract(url, libName);
                }
                System.load(path.toAbsolutePath().toString());
                return;
            }
        }
        System.loadLibrary(libName);
    }

    private static String[] getLibPaths(String libName) {
        String path = OperatingSystem.CURRENT.lowerName() + "/" + Architecture.CURRENT.lowerName() + "/";
        if (OperatingSystem.CURRENT.isLinux()) {
            return new String[]{path + System.mapLibraryName(libName + LibC.LIBC_SUFFIX), path + System.mapLibraryName(libName)};
        }
        return new String[]{path + System.mapLibraryName(libName)};
    }

    private static Path getAsAbsolutePath(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                Path file = Paths.get(url.toURI());
                if (file.isAbsolute() && Files.isReadable(file)) {
                    return file;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Path extract(URL url, String libName) {
        try {
            Path tempDir = Files.createTempDirectory("libcurl4j-natives", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Path libPath = tempDir.resolve(System.mapLibraryName(libName));
            try (InputStream is = url.openStream();){
                Files.copy(is, libPath, new CopyOption[0]);
            }
            return libPath;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to extract library.", ex);
        }
    }

    static {
        LibraryLoader.loadJNILibrary(System.getProperty("net.covers1624.curl4j.libcurl4j.name", "curl4j"));
    }
}

