/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.util.concurrent.atomic.AtomicLong;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.ErrorBuffer;
import net.covers1624.curl4j.util.internal.CurlHandleFactory;

public class CurlHandle
implements AutoCloseable {
    public final long curl;
    public final ErrorBuffer errorBuffer = new ErrorBuffer();
    private final AtomicLong a_curl;

    public CurlHandle() {
        this(new AtomicLong(CURL.curl_easy_init()));
    }

    protected CurlHandle(AtomicLong a_curl) {
        this.curl = a_curl.get();
        this.a_curl = a_curl;
        this.errorBuffer.apply(this.curl);
    }

    public static CurlHandle create() {
        return CurlHandleFactory.INSTANCE.newHandle(new AtomicLong(CURL.curl_easy_init()));
    }

    public static ThreadLocal<CurlHandle> newThreadLocal() {
        return ThreadLocal.withInitial(CurlHandle::create);
    }

    @Override
    public void close() {
        if (this.a_curl.compareAndSet(this.curl, 0L)) {
            CURL.curl_easy_cleanup(this.curl);
        }
    }
}

