/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.CurlReadCallback;
import net.covers1624.curl4j.CurlSeekCallback;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.util.CurlBindable;
import org.jetbrains.annotations.Nullable;

public abstract class CurlInput
implements Closeable,
CurlBindable {
    @Nullable
    private CurlReadCallback readCallback;
    @Nullable
    private CurlSeekCallback seekCallback;
    @Nullable
    private ReadableByteChannel channel;
    private boolean closed;

    public static CurlInput fromChannel(final InputSupplier<ReadableByteChannel> supplier) {
        return new CurlInput(){

            @Override
            protected ReadableByteChannel open() throws IOException {
                return (ReadableByteChannel)supplier.open();
            }

            @Override
            public long availableBytes() {
                return -1L;
            }
        };
    }

    public static CurlInput fromStream(final InputSupplier<InputStream> supplier) {
        return new CurlInput(){
            @Nullable
            private InputStream is;

            @Override
            protected ReadableByteChannel open() throws IOException {
                return Channels.newChannel(this.getStream());
            }

            @Override
            public long availableBytes() throws IOException {
                return this.getStream().available();
            }

            private InputStream getStream() throws IOException {
                if (this.is == null) {
                    this.is = (InputStream)supplier.open();
                }
                return this.is;
            }
        };
    }

    public static CurlInput fromFile(final Path path) {
        return new CurlInput(){

            @Override
            protected ReadableByteChannel open() throws IOException {
                return Files.newByteChannel(path, new OpenOption[0]);
            }

            @Override
            public long availableBytes() throws IOException {
                return Files.size(path);
            }
        };
    }

    public static CurlInput fromFile(File path) {
        return CurlInput.fromFile(path.toPath());
    }

    public static CurlInput fromBytes(final byte[] bytes) {
        return new CurlInput(){

            @Override
            protected ReadableByteChannel open() throws IOException {
                return Channels.newChannel(new ByteArrayInputStream(bytes));
            }

            @Override
            public long availableBytes() throws IOException {
                return bytes.length;
            }
        };
    }

    public CurlReadCallback callback() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        if (this.readCallback == null) {
            this.readCallback = new CurlReadCallback((ptr, size, nmemb, userdata) -> {
                int rs;
                ByteBuffer buffer;
                int len;
                if (this.channel == null) {
                    this.channel = this.open();
                }
                return (len = this.channel.read(buffer = Memory.newDirectByteBuffer(ptr, rs = (int)(size * nmemb)))) != -1 ? (long)len : 0L;
            });
        }
        return this.readCallback;
    }

    public CurlSeekCallback seekCallback() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        if (this.seekCallback == null) {
            this.seekCallback = new CurlSeekCallback((userdata, offset, origin) -> {
                if (origin != 0) {
                    return 2;
                }
                if (!(this.channel instanceof SeekableByteChannel)) {
                    return 2;
                }
                ((SeekableByteChannel)this.channel).position(offset);
                return 0;
            });
        }
        return this.seekCallback;
    }

    @Override
    public void apply(long curl) throws IOException {
        long len = this.availableBytes();
        if (len == -1L) {
            throw new IllegalStateException("Must have a known length.");
        }
        CURL.curl_easy_setopt(curl, 46, true);
        CURL.curl_easy_setopt(curl, 30115, len);
        CURL.curl_easy_setopt(curl, 20012, this.callback());
        CURL.curl_easy_setopt(curl, 20167, this.seekCallback());
    }

    protected abstract ReadableByteChannel open() throws IOException;

    public abstract long availableBytes() throws IOException;

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.readCallback != null) {
            this.readCallback.close();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.closed = true;
    }

    @FunctionalInterface
    public static interface InputSupplier<T> {
        public T open() throws IOException;
    }
}

