/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.util.CurlBindable;
import net.covers1624.curl4j.util.CurlHandle;
import net.covers1624.curl4j.util.CurlInput;

public class CurlMimeBody
implements Closeable,
CurlBindable {
    private final long mime;
    private final List<Closeable> resources;

    private CurlMimeBody(long mime, List<Closeable> resources) {
        this.mime = mime;
        this.resources = resources;
    }

    public long getMime() {
        return this.mime;
    }

    @Override
    public void close() throws IOException {
        CURL.curl_mime_free(this.mime);
        for (Closeable resource : this.resources) {
            try {
                resource.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void apply(long curl) {
        CURL.curl_easy_setopt(curl, 10269, this.getMime());
    }

    public static Builder builder(CurlHandle handle) {
        return CurlMimeBody.builder(handle.curl);
    }

    public static Builder builder(long curl) {
        return new Builder(curl);
    }

    public static final class Builder {
        private final long mime;
        private final List<Closeable> resources = new LinkedList<Closeable>();

        private Builder(long curl) {
            this.mime = CURL.curl_mime_init(curl);
        }

        public PartBuilder addPart(String name) {
            return new PartBuilder(name);
        }

        public long getMime() {
            return this.mime;
        }

        public CurlMimeBody build() {
            return new CurlMimeBody(this.mime, this.resources);
        }

        public class PartBuilder {
            private final long part;

            private PartBuilder(String name) {
                this.part = CURL.curl_mime_addpart(Builder.this.mime);
                CURL.curl_mime_name(this.part, name);
            }

            public PartBuilder fileName(String fileName) {
                CURL.curl_mime_filename(this.part, fileName);
                return this;
            }

            public PartBuilder type(String type) {
                CURL.curl_mime_type(this.part, type);
                return this;
            }

            public PartBuilder body(byte[] data) {
                CURL.curl_mime_data(this.part, data);
                return this;
            }

            public PartBuilder body(CurlInput input) {
                long len;
                try {
                    len = input.availableBytes();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to query input for length.", e);
                }
                if (len == -1L) {
                    throw new IllegalArgumentException("Input must have a known length.");
                }
                Builder.this.resources.add(input);
                CURL.curl_mime_data_cb(this.part, len, input.callback(), input.seekCallback());
                return this;
            }

            public long getPart() {
                return this.part;
            }

            public Builder build() {
                return Builder.this;
            }
        }
    }
}

