/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Locale;
import net.covers1624.curl4j.core.OperatingSystem;

public enum LibC {
    GNU,
    MUSL,
    UNKNOWN;

    private static final boolean DEBUG_LIBC;
    private static final boolean IS_LINUX;
    public static final LibC CURRENT;
    public static final String LIBC_SUFFIX;

    public String getSuffix() {
        if (this == UNKNOWN) {
            return GNU.getSuffix();
        }
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static LibC probeLibC() {
        try {
            Process process = new ProcessBuilder("ldd", "--version").redirectErrorStream(true).start();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (InputStream is = process.getInputStream();){
                int len;
                byte[] buf = new byte[1024];
                while ((len = is.read(buf, 0, 1024)) != -1) {
                    bos.write(buf, 0, len);
                }
            }
            String str = bos.toString("UTF-8");
            if (str.contains("GNU libc") || str.contains("GLIBC")) {
                return GNU;
            }
            if (str.contains("musl")) {
                return MUSL;
            }
            if (DEBUG_LIBC) {
                System.err.println("[curl4j] Failed to detect LibC variant from LDD output: " + str);
            }
            return UNKNOWN;
        }
        catch (Throwable ex) {
            if (DEBUG_LIBC) {
                System.err.println("[curl4j] Failed to detect LibC version.");
                ex.printStackTrace(System.err);
            }
            return UNKNOWN;
        }
    }

    static {
        DEBUG_LIBC = Boolean.getBoolean("net.covers1624.curl4j.debug_libc");
        IS_LINUX = OperatingSystem.CURRENT.isLinux();
        CURRENT = IS_LINUX ? LibC.probeLibC() : UNKNOWN;
        LIBC_SUFFIX = IS_LINUX ? "-" + CURRENT.getSuffix() : "";
    }
}

