/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.httpapi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.CURLMsg;
import net.covers1624.curl4j.CurlWriteCallback;
import net.covers1624.curl4j.CurlXferInfoCallback;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.core.Pointer;
import net.covers1624.curl4j.httpapi.Curl4jEngineRequest;
import net.covers1624.curl4j.httpapi.Curl4jEngineResponse;
import net.covers1624.curl4j.httpapi.Curl4jHttpException;
import net.covers1624.curl4j.httpapi.HandlePool;
import net.covers1624.curl4j.httpapi.NativeBuffer;
import net.covers1624.curl4j.util.CurlHandle;
import net.covers1624.curl4j.util.CurlInput;
import net.covers1624.curl4j.util.CurlMimeBody;
import net.covers1624.curl4j.util.CurlMultiHandle;
import net.covers1624.curl4j.util.HeaderCollector;
import net.covers1624.curl4j.util.SListHeaderWrapper;
import net.covers1624.quack.net.httpapi.HeaderList;
import net.covers1624.quack.net.httpapi.WebBody;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

class IncrementalCurl4jResponse
extends Curl4jEngineResponse {
    private static final HandlePool<NativeBuffer> BUFFERS = new HandlePool<NativeBuffer>(() -> new NativeBuffer(65536L));
    private final HandlePool.Entry bufEnt = BUFFERS.get();
    private long buf;
    private ByteBuffer buffer;
    private boolean done;
    private boolean paused;
    private final Curl4jEngineRequest request;
    private final HandlePool.Entry handleEntry;
    private final CurlMultiHandle handle;
    @Nullable
    private final CurlInput input;
    @Nullable
    private final CurlMimeBody mimeBody;
    private final SListHeaderWrapper headers;
    @Nullable
    private final CurlXferInfoCallback xferCallback;
    private final int statusCode;
    private final HeaderList responseHeaders;
    private final CurlWriteCallback writeCallback;
    private final InputStream is;
    private final ReadableByteChannel channel;
    private final WebBody webBody;

    public IncrementalCurl4jResponse(Curl4jEngineRequest request, HandlePool.Entry handleEntry) throws IOException {
        this.buf = ((NativeBuffer)this.bufEnt.handle).address;
        this.buffer = ((NativeBuffer)this.bufEnt.handle).buffer;
        this.responseHeaders = new HeaderList();
        this.writeCallback = new CurlWriteCallback((ptr, size, nmemb, userdata) -> {
            int rs = (int)(size * nmemb);
            if (rs == 0) {
                return rs;
            }
            if (this.buffer.remaining() < rs) {
                if (this.buffer.position() != 0) {
                    this.paused = true;
                    return 0x10000001L;
                }
                this.growBuffer(rs - this.buffer.remaining());
            }
            Memory.memcpy(ptr, this.buf + (long)this.buffer.position(), rs);
            this.buffer.position(this.buffer.position() + rs);
            return rs;
        });
        this.is = new InputStream(){

            @Override
            public int read() throws IOException {
                if (IncrementalCurl4jResponse.this.buffer.remaining() == 0) {
                    if (IncrementalCurl4jResponse.this.done) {
                        return -1;
                    }
                    IncrementalCurl4jResponse.this.fillBuffer();
                }
                return IncrementalCurl4jResponse.this.buffer.get() & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (IncrementalCurl4jResponse.this.buffer.remaining() == 0) {
                    if (IncrementalCurl4jResponse.this.done) {
                        return -1;
                    }
                    IncrementalCurl4jResponse.this.fillBuffer();
                }
                int l = Math.min(len, IncrementalCurl4jResponse.this.buffer.remaining());
                IncrementalCurl4jResponse.this.buffer.get(b, off, l);
                return l;
            }
        };
        this.channel = new ReadableByteChannel(){
            private boolean open = true;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (IncrementalCurl4jResponse.this.buffer.remaining() == 0) {
                    if (IncrementalCurl4jResponse.this.done) {
                        return -1;
                    }
                    IncrementalCurl4jResponse.this.fillBuffer();
                }
                int toRead = Math.min(dst.remaining(), IncrementalCurl4jResponse.this.buffer.remaining());
                int oldL = IncrementalCurl4jResponse.this.buffer.limit();
                IncrementalCurl4jResponse.this.buffer.limit(IncrementalCurl4jResponse.this.buffer.position() + toRead);
                dst.put(IncrementalCurl4jResponse.this.buffer);
                IncrementalCurl4jResponse.this.buffer.limit(oldL);
                return toRead;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public void close() {
                this.open = false;
            }
        };
        this.request = request;
        this.handleEntry = handleEntry;
        this.handle = (CurlMultiHandle)handleEntry.handle;
        this.input = request.makeInput();
        this.mimeBody = request.buildMime(this.handle);
        this.headers = new SListHeaderWrapper(request.headers().toStrings());
        this.xferCallback = request.xferCallback(request.listener());
        try (HeaderCollector headerCollector = new HeaderCollector();){
            if (this.input != null) {
                this.input.apply(this.handle);
            } else if (this.mimeBody != null) {
                this.mimeBody.apply(this.handle);
            }
            this.headers.apply(this.handle);
            headerCollector.apply(this.handle);
            CURL.curl_easy_setopt(this.handle.curl, 20011, this.writeCallback.getFunctionAddress());
            if (request.caBundle() != null) {
                request.caBundle().apply(this.handle);
            }
            if (this.xferCallback != null) {
                CURL.curl_easy_setopt(this.handle.curl, 43, false);
                CURL.curl_easy_setopt(this.handle.curl, 20219, this.xferCallback);
            }
            CURL.curl_easy_setopt(this.handle.curl, 99, true);
            for (Consumer<CurlHandle> customOption : request.customOptions()) {
                customOption.accept(this.handle);
            }
            CURL.curl_multi_add_handle(this.handle.multi, this.handle.curl);
            this.fillBuffer();
            this.statusCode = (int)CURL.curl_easy_getinfo_long(this.handle.curl, 0x200002);
            this.responseHeaders.addAllMulti(headerCollector.getHeaders());
            final String contentType = this.responseHeaders.get("Content-Type");
            String len = this.responseHeaders.get("Content-Length");
            final long contentLength = len != null && !len.isEmpty() ? Long.parseLong(len) : -1L;
            this.webBody = new WebBody(){

                public InputStream open() {
                    return IncrementalCurl4jResponse.this.is;
                }

                public ReadableByteChannel openChannel() {
                    return IncrementalCurl4jResponse.this.channel;
                }

                public boolean multiOpenAllowed() {
                    return false;
                }

                public long length() {
                    return contentLength;
                }

                @Nullable
                public String contentType() {
                    return contentType;
                }
            };
        }
    }

    private void fillBuffer() throws IOException {
        assert (this.buffer.position() == 0 || this.buffer.position() == this.buffer.limit()) : "Buffer must either be empty or fully consumed.";
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        if (this.paused) {
            this.paused = false;
            CURL.curl_easy_pause(this.handle.curl, 0);
        }
        try (Memory.Stack stack = Memory.pushStack();){
            Pointer nHandles = stack.mallocPointer();
            Pointer nEvents = stack.mallocPointer();
            while (!this.done && !this.paused) {
                int ret = CURL.curl_multi_perform(this.handle.multi, nHandles);
                if (ret != 0) {
                    throw new Curl4jHttpException("Curl multi returned error: " + this.handle.errorBuffer + "(" + CURL.curl_multi_strerror(ret) + ")");
                }
                ret = CURL.curl_multi_wait(this.handle.multi, 10000000, nEvents);
                if (ret != 0) {
                    throw new Curl4jHttpException("Curl multi wait returned error: " + this.handle.errorBuffer + "(" + CURL.curl_multi_strerror(ret) + ")");
                }
                this.done = nHandles.readInt() == 0;
            }
            if (this.done) {
                CURLMsg msg;
                while ((msg = CURL.curl_multi_info_read(this.handle.multi, nHandles)) != null) {
                    int ret;
                    if (msg.msg() != 1 || (ret = (int)msg.data()) == 0) continue;
                    throw new Curl4jHttpException("Curl returned error: " + this.handle.errorBuffer + "(" + CURL.curl_easy_strerror(ret) + ")");
                }
            }
        }
        this.buffer.flip();
    }

    private void growBuffer(int more) {
        int newSize = this.buffer.limit() + more;
        this.bufEnt.handle = ((NativeBuffer)this.bufEnt.handle).newRealloc(newSize);
        ((NativeBuffer)this.bufEnt.handle).buffer.position(this.buffer.position());
        this.buf = ((NativeBuffer)this.bufEnt.handle).address;
        this.buffer = ((NativeBuffer)this.bufEnt.handle).buffer;
    }

    public void close() throws IOException {
        CURL.curl_multi_remove_handle(this.handle.multi, this.handle.curl);
        ((NativeBuffer)this.bufEnt.handle).buffer.position(0);
        ((NativeBuffer)this.bufEnt.handle).buffer.limit(((NativeBuffer)this.bufEnt.handle).buffer.capacity());
        IncrementalCurl4jResponse.closeSafe(this.writeCallback, this.input, this.mimeBody, this.headers, this.xferCallback, this.handleEntry, this.bufEnt);
        if (this.request.listener() != null) {
            this.request.listener().end();
        }
    }

    private static void closeSafe(AutoCloseable ... closeables) {
        Throwable exception = null;
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            SneakyUtils.throwUnchecked(exception);
        }
    }

    @Override
    public Curl4jEngineRequest request() {
        return this.request;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String message() {
        return "";
    }

    public HeaderList headers() {
        return this.responseHeaders;
    }

    public WebBody body() {
        return this.webBody;
    }
}

