/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.util.concurrent.atomic.AtomicLong;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.util.CurlHandle;
import net.covers1624.curl4j.util.internal.CurlHandleFactory;

public class CurlMultiHandle
extends CurlHandle {
    public final long multi;
    private final AtomicLong a_multi;

    public CurlMultiHandle() {
        this(new AtomicLong(CURL.curl_easy_init()), new AtomicLong(CURL.curl_multi_init()));
    }

    protected CurlMultiHandle(AtomicLong a_curl, AtomicLong a_multi) {
        super(a_curl);
        this.multi = a_multi.get();
        this.a_multi = a_multi;
    }

    public static CurlMultiHandle createMulti() {
        return CurlHandleFactory.INSTANCE.newMultiHandle(new AtomicLong(CURL.curl_easy_init()), new AtomicLong(CURL.curl_multi_init()));
    }

    public static ThreadLocal<CurlMultiHandle> newMultiThreadLocal() {
        return ThreadLocal.withInitial(CurlMultiHandle::createMulti);
    }

    @Override
    public void close() {
        super.close();
        if (this.a_multi.compareAndSet(this.multi, 0L)) {
            CURL.curl_multi_cleanup(this.multi);
        }
    }
}

