/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util.internal;

import java.lang.ref.Cleaner;
import java.util.concurrent.atomic.AtomicLong;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.util.CurlHandle;
import net.covers1624.curl4j.util.CurlMultiHandle;
import net.covers1624.curl4j.util.internal.CurlHandleFactory;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CleaningCurlHandleFactory
implements CurlHandleFactory {
    private final Cleaner CLEANER = Cleaner.create();

    @Override
    public CurlHandle newHandle(AtomicLong a_curl) {
        long curl = a_curl.get();
        CleaningCurlHandle handle = new CleaningCurlHandle(a_curl);
        this.CLEANER.register(handle, () -> {
            if (a_curl.compareAndSet(curl, 0L)) {
                CURL.curl_easy_cleanup(curl);
            }
        });
        return handle;
    }

    @Override
    public CurlMultiHandle newMultiHandle(AtomicLong a_curl, AtomicLong a_multi) {
        long curl = a_curl.get();
        long multi = a_multi.get();
        CleaningCurlMultiHandle handle = new CleaningCurlMultiHandle(a_curl, a_multi);
        this.CLEANER.register(handle, () -> {
            if (a_curl.compareAndSet(curl, 0L)) {
                CURL.curl_easy_cleanup(curl);
            }
            if (a_multi.compareAndSet(multi, 0L)) {
                CURL.curl_multi_cleanup(multi);
            }
        });
        return handle;
    }

    private static class CleaningCurlMultiHandle
    extends CurlMultiHandle {
        public CleaningCurlMultiHandle(AtomicLong curl, AtomicLong multi) {
            super(curl, multi);
        }
    }

    private static class CleaningCurlHandle
    extends CurlHandle {
        public CleaningCurlHandle(AtomicLong curl) {
            super(curl);
        }
    }
}

