/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.controller.v2;

import java.io.IOException;
import net.javasauce.cibot.data.ApiResponse;
import net.javasauce.cibot.data.GenKeyResponse;
import net.javasauce.cibot.service.AuthService;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/v2/auth"})
public class AuthControllerV2 {
    private final AuthService authService;

    public AuthControllerV2(AuthService authService) {
        this.authService = authService;
    }

    @PostMapping(value={"gen_key"}, consumes={"text/plain"})
    public ResponseEntity<ApiResponse> genKey(@RequestParam(value="head_commit") String headCommit, @RequestParam(value="run_id") long runId, @RequestParam(value="pr_id", required=false, defaultValue="-1") long prId, @RequestBody String apiKey) throws IOException {
        this.authService.checkAuth(headCommit, runId, prId, apiKey);
        return ResponseEntity.ok((Object)new GenKeyResponse(this.authService.generateTemporaryKey().getSecret()));
    }
}

