/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.entity;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.List;
import java.util.Map;
import net.javasauce.cibot.entity.VersionFile;
import net.javasauce.cibot.util.TestCaseState;

@Entity(name="variants")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"notation", "commit"})})
public class ArtifactVariant {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    private String notation;
    @Column(nullable=false)
    private String commit;
    @ManyToMany
    private List<VersionFile> files;
    @ElementCollection
    private Map<String, TestCaseState> cases;

    public ArtifactVariant() {
    }

    public ArtifactVariant(String notation, String commit, List<VersionFile> files, Map<String, TestCaseState> cases) {
        this.notation = notation;
        this.commit = commit;
        this.files = files;
        this.cases = cases;
    }

    public int getId() {
        return this.id;
    }

    public String getNotation() {
        return this.notation;
    }

    public String getCommit() {
        return this.commit;
    }

    public List<VersionFile> getFiles() {
        return this.files;
    }

    public Map<String, TestCaseState> getCases() {
        return this.cases;
    }
}

