/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.diffpatch.util.archiver.ArchiveReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public record Archive(byte[] bytes, ArchiveFormat format) {
    private final byte[] bytes;
    private final ArchiveFormat format;

    public Archive(byte[] bytes, ArchiveFormat format) {
        this.bytes = bytes;
        this.format = format;
    }

    public ArchiveReader open() throws IOException {
        return this.format.createReader((InputStream)new ByteArrayInputStream(this.bytes));
    }

    public String hashFiles() {
        String string;
        block9: {
            Hasher hasher = Hashing.sha256().newHasher();
            ArchiveReader reader = this.open();
            try {
                for (String entry : reader.getEntries()) {
                    byte[] bytes = reader.getBytes(entry);
                    hasher.putInt(bytes.length);
                    hasher.putBytes(bytes);
                }
                string = hasher.hash().toString();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Unable to read archive.", ex);
                }
            }
            reader.close();
        }
        return string;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public ArchiveFormat format() {
        return this.format;
    }
}

