/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.security;

import jakarta.servlet.Filter;
import java.time.Instant;
import net.javasauce.cibot.entity.ApiKey;
import net.javasauce.cibot.repo.ApiKeyRepo;
import net.javasauce.cibot.security.ApiAuth;
import net.javasauce.cibot.security.ApiKeyAuthFilter;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class WebSecurityConfig {
    private final ApiKeyRepo apiKeyRepo;

    public WebSecurityConfig(ApiKeyRepo apiKeyRepo) {
        this.apiKeyRepo = apiKeyRepo;
    }

    @Bean
    public SecurityFilterChain auth(HttpSecurity security) throws Throwable {
        security.headers(AbstractHttpConfigurer::disable).addFilter((Filter)this.createFilter()).csrf(AbstractHttpConfigurer::disable).sessionManagement(e -> e.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).securityMatcher(new String[]{"/api/**"}).authorizeHttpRequests(e -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)e.requestMatchers(new String[]{"/api/v1/**"})).permitAll().requestMatchers(new String[]{"/api/v2/auth/gen_key"})).permitAll().anyRequest()).authenticated());
        return (SecurityFilterChain)security.build();
    }

    @NotNull
    private ApiKeyAuthFilter createFilter() {
        ApiKeyAuthFilter filter = new ApiKeyAuthFilter();
        filter.setAuthenticationManager(auth -> {
            String principal = (String)auth.getPrincipal();
            ApiKey apiKey = this.apiKeyRepo.findBySecret(principal);
            if (apiKey == null) {
                throw new BadCredentialsException("Invalid API Key.");
            }
            Instant expiry = apiKey.getExpiry();
            if (expiry != null && Instant.now().isAfter(expiry)) {
                throw new BadCredentialsException("ApiKey has expired.");
            }
            return new ApiAuth(apiKey);
        });
        return filter;
    }
}

