/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.service;

import jakarta.transaction.Transactional;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.covers1624.quack.collection.ColUtils;
import net.javasauce.cibot.entity.ApiKey;
import net.javasauce.cibot.repo.ApiKeyRepo;
import net.javasauce.cibot.security.ApiAuth;
import net.javasauce.cibot.service.GitHubService;
import net.javasauce.cibot.util.AuthFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class AuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthService.class);
    private final ApiKeyRepo apiKeyRepo;
    private final GitHubService github;

    public AuthService(ApiKeyRepo apiKeyRepo, GitHubService github) {
        this.apiKeyRepo = apiKeyRepo;
        this.github = github;
    }

    public void checkAuth(String headCommit, long runId, long prId, String apiKey) throws IOException {
        LOGGER.info("Attempting auth for RunId {} (PR {})", (Object)runId, (Object)prId);
        GitHubService.WorkflowRun run = this.github.getWorkflowRun(runId, apiKey);
        LOGGER.info("Auth for {} got status {}", (Object)runId, (Object)run.status());
        if (!run.headSha().equals(headCommit)) {
            throw new AuthFailure("Workflow head commit does not match.");
        }
        if (!run.status().equals("in_progress")) {
            throw new AuthFailure("Workflow has already completed.");
        }
        if (prId != -1L && !ColUtils.anyMatch((Iterable)run.pullRequests(), e -> (long)e.number() == prId)) {
            throw new AuthFailure("Workflow is not running for a PR.");
        }
    }

    public void checkKey(ApiAuth auth) {
        ApiKey key = auth.apiKey();
        Instant expiry = key.getExpiry();
        if (key.isSingleUse()) {
            this.apiKeyRepo.delete((Object)key);
        }
        if (expiry != null && Instant.now().isAfter(expiry)) {
            throw new AuthFailure("Key is expired.");
        }
    }

    public ApiKey generateTemporaryKey() {
        ApiKey key = new ApiKey(UUID.randomUUID().toString(), Instant.now().plus(10L, ChronoUnit.SECONDS), true);
        this.apiKeyRepo.save((Object)key);
        return key;
    }

    @Scheduled(initialDelay=0L, fixedDelay=6L, timeUnit=TimeUnit.HOURS)
    @Transactional
    public void pollForDeadKeys() {
        for (ApiKey apiKey : this.apiKeyRepo.findAllByExpiryNotNull()) {
            Instant expiry = apiKey.getExpiry();
            if (expiry == null || !Instant.now().isAfter(expiry)) continue;
            LOGGER.info("Cleaning up dead key {} {}", (Object)apiKey.getId(), (Object)apiKey.getSecret());
            this.apiKeyRepo.delete((Object)apiKey);
        }
    }
}

