/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.service;

import com.google.common.collect.Sets;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.maven.MavenNotation;
import net.javasauce.cibot.CIBotProperties;
import net.javasauce.cibot.data.ApiResponse;
import net.javasauce.cibot.entity.ArtifactVariant;
import net.javasauce.cibot.entity.PullRequest;
import net.javasauce.cibot.repo.ArtifactVariantRepo;
import net.javasauce.cibot.repo.PullRequestRepo;
import net.javasauce.cibot.service.ArtifactService;
import net.javasauce.cibot.service.BuildService;
import net.javasauce.cibot.service.DiffService;
import net.javasauce.cibot.service.GitHubService;
import net.javasauce.cibot.util.TestCaseState;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BuildService {
    private static final String GS = "\ud83d\udfe9";
    private static final String RS = "\ud83d\udfe5";
    private static final Logger LOGGER = LogManager.getLogger();
    private final CIBotProperties properties;
    private final ArtifactVariantRepo variantRepo;
    private final PullRequestRepo prRepo;
    private final ArtifactService artifactService;
    private final DiffService diffService;
    private final GitHubService githubService;

    public BuildService(CIBotProperties properties, ArtifactVariantRepo variantRepo, PullRequestRepo prRepo, ArtifactService artifactService, DiffService diffService, GitHubService githubService) {
        this.properties = properties;
        this.variantRepo = variantRepo;
        this.prRepo = prRepo;
        this.artifactService = artifactService;
        this.diffService = diffService;
        this.githubService = githubService;
    }

    public ResponseEntity<ApiResponse> postUpdate(String baseCommit, String headCommit, long prId, String apiKey) throws IOException {
        LOGGER.info("Handling post update for {} and {}. PR {}", (Object)baseCommit, (Object)headCommit, (Object)prId);
        LinkedList<Object> summary = new LinkedList<Object>();
        summary.add("## Test Results");
        LinkedList<String> table = new LinkedList<String>();
        table.add("<table>");
        table.add("<tr>");
        table.add("<td>Libraries</td>");
        table.add("<td>Summary</td>");
        table.add("<td>Improved</td>");
        table.add("<td>Regressed</td>");
        table.add("<td>Changed</td>");
        table.add("</tr>");
        boolean foundAny = false;
        for (ArtifactVariant headVariant : this.variantRepo.findAllByCommit(headCommit)) {
            String notationString = headVariant.getNotation();
            MavenNotation notation = MavenNotation.parse((String)notationString);
            LOGGER.info("Processing {}", (Object)notation);
            ArtifactVariant baseVariant = this.variantRepo.findByNotationAndCommit(notationString, baseCommit);
            boolean fuzzy = false;
            if (baseVariant == null) {
                List allVariants = this.variantRepo.findAllByCommit(baseCommit);
                baseVariant = (ArtifactVariant)FastStream.of((Iterable)allVariants).filter(e -> BuildService.fuzzyMatchNotation((MavenNotation)notation, (MavenNotation)MavenNotation.parse((String)e.getNotation()))).onlyOrDefault();
                if (baseVariant == null) {
                    LOGGER.warn("Did not find matching base notation for {} in {}", (Object)notationString, (Object)FastStream.of((Iterable)allVariants).map(ArtifactVariant::getNotation).toList());
                    continue;
                }
                LOGGER.info(" Fuzzy matched {} for the base variant", (Object)baseVariant.getNotation());
                fuzzy = true;
            }
            CaseComparison comparison = this.compareCases(baseVariant, headVariant);
            boolean showDiffs = !notation.group.equals("net.minecraft") || !fuzzy;
            table.add("<tr>");
            if (fuzzy) {
                MavenNotation baseNotation = MavenNotation.parse((String)baseVariant.getNotation());
                BuildService.emitTableCell(table, (String)("`" + BuildService.toDisplayName((MavenNotation)baseNotation) + "` -> `" + BuildService.toDisplayName((MavenNotation)notation) + "`"));
            } else {
                BuildService.emitTableCell(table, (String)("`" + BuildService.toDisplayName((MavenNotation)notation) + "`"));
            }
            BuildService.emitTableCell(table, (List)this.buildComparisonSummary(comparison));
            LOGGER.info("Building Improved gists..");
            BuildService.emitTableCell(table, (String)(showDiffs ? this.buildGistsFor(baseVariant, headVariant, arg_0 -> ((CaseComparison)comparison).fileImproved(arg_0), notationString + " Improved Diff " + baseCommit + " -> " + headCommit) : ""));
            LOGGER.info("Building Regressed gists..");
            BuildService.emitTableCell(table, (String)(showDiffs ? this.buildGistsFor(baseVariant, headVariant, arg_0 -> ((CaseComparison)comparison).fileRegressed(arg_0), notationString + " Regressed Diff " + baseCommit + " -> " + headCommit) : ""));
            LOGGER.info("Building Changes gists..");
            BuildService.emitTableCell(table, (String)(showDiffs ? this.buildGistsFor(baseVariant, headVariant, arg_0 -> ((CaseComparison)comparison).fileChanged(arg_0), notationString + " Diff " + baseCommit + " -> " + headCommit) : ""));
            table.add("</tr>");
            foundAny = true;
        }
        table.add("</table>");
        if (foundAny) {
            summary.addAll(table);
        } else {
            summary.add("No files exist for comparison :(");
        }
        summary.add("");
        summary.add("Results for commit " + this.formatCommitLink(headCommit) + ". \u00b1 Comparison against base commit " + this.formatCommitLink(baseCommit));
        if (prId != -1L) {
            PullRequest pr = this.prRepo.findById(prId);
            if (pr == null) {
                pr = new PullRequest(prId);
                this.prRepo.save((Object)pr);
            }
            if (pr.getCommentId() == -1L) {
                LOGGER.info("Posting Github comment..");
                pr.setCommentId(this.githubService.addComment(prId, apiKey, String.join((CharSequence)"\n", summary)));
                this.prRepo.save((Object)pr);
            } else {
                LOGGER.info("Updating Github comment..");
                this.githubService.updateComment(pr.getCommentId(), apiKey, String.join((CharSequence)"\n", summary));
            }
        }
        LOGGER.info("\n" + String.join((CharSequence)"\n", summary));
        return ApiResponse.ok((String)String.join((CharSequence)"\n", summary));
    }

    private static String toDisplayName(MavenNotation notation) {
        String displayName = notation.module + ":" + notation.version;
        if (!notation.group.equals("net.minecraft")) {
            return displayName;
        }
        return "mc_" + displayName;
    }

    private static boolean fuzzyMatchNotation(MavenNotation headNotation, MavenNotation baseNotation) {
        if (!headNotation.module.equals(baseNotation.module)) {
            return false;
        }
        return headNotation.group.equals(baseNotation.group) || baseNotation.group.equals("net.covers1624.j8libs." + headNotation.module);
    }

    private static void emitTableCell(List<String> table, String cellContent) {
        BuildService.emitTableCell(table, List.of(cellContent));
    }

    private static void emitTableCell(List<String> table, List<String> cellContent) {
        if (ColUtils.allMatch(cellContent, String::isEmpty)) {
            table.add("<td></td>");
        } else {
            table.add("<td>");
            table.add("");
            table.addAll(cellContent);
            table.add("");
            table.add("</td>");
        }
    }

    private String formatCommitLink(String commit) {
        commit = StringUtils.substring((String)commit, (int)0, (int)8);
        return "[`" + commit + "`](https://github.com/" + this.properties.getGithubOwner() + "/" + this.properties.getGithubRepo() + "/commit/" + commit + ")";
    }

    private CaseComparison compareCases(ArtifactVariant base, ArtifactVariant head) {
        TestCaseState state;
        LOGGER.info("Comparing cases..");
        HashMap b = new HashMap(base.getCases());
        HashMap h = new HashMap(head.getCases());
        int[] numCases = new int[4];
        for (TestCaseState value : h.values()) {
            int n = value.ordinal();
            numCases[n] = numCases[n] + 1;
        }
        Sets.SetView newCases = Sets.difference(h.keySet(), b.keySet());
        Sets.SetView remCases = Sets.difference(b.keySet(), h.keySet());
        int[] addedTotal = new int[4];
        int[] removedTotal = new int[4];
        int[] improvedStats = new int[4];
        int[] regressedStats = new int[4];
        int[] newStats = new int[4];
        int[] removedStats = new int[4];
        HashSet<String> improvedCases = new HashSet<String>();
        HashSet<String> regressedCases = new HashSet<String>();
        for (String name : Sets.intersection(b.keySet(), h.keySet())) {
            TestCaseState hState;
            TestCaseState bState = (TestCaseState)b.get(name);
            if (bState == (hState = (TestCaseState)h.get(name))) continue;
            int n = bState.ordinal();
            removedTotal[n] = removedTotal[n] + 1;
            int n2 = hState.ordinal();
            addedTotal[n2] = addedTotal[n2] + 1;
            if (hState.ordinal() > bState.ordinal()) {
                int n3 = hState.ordinal();
                improvedStats[n3] = improvedStats[n3] + 1;
                improvedCases.add(name);
                continue;
            }
            int n4 = hState.ordinal();
            regressedStats[n4] = regressedStats[n4] + 1;
            regressedCases.add(name);
        }
        for (String name : newCases) {
            state = (TestCaseState)h.get(name);
            int n = state.ordinal();
            newStats[n] = newStats[n] + 1;
            int n5 = state.ordinal();
            addedTotal[n5] = addedTotal[n5] + 1;
        }
        for (String name : remCases) {
            state = (TestCaseState)b.get(name);
            int n = state.ordinal();
            removedStats[n] = removedStats[n] + 1;
            int n6 = state.ordinal();
            removedTotal[n6] = removedTotal[n6] + 1;
        }
        return new CaseComparison(numCases, newCases.size(), remCases.size(), addedTotal, removedTotal, improvedStats, regressedStats, newStats, removedStats, improvedCases, regressedCases);
    }

    private List<String> buildComparisonSummary(CaseComparison comp) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("```");
        Object addedRemoved = "";
        if (comp.newCases > 0) {
            addedRemoved = comp.newCases + " new";
        }
        if (comp.removedCases > 0) {
            if (!((String)addedRemoved).isEmpty()) {
                addedRemoved = (String)addedRemoved + " ";
            }
            addedRemoved = (String)addedRemoved + comp.removedCases + " removed";
        }
        if (!((String)addedRemoved).isEmpty()) {
            lines.add((String)addedRemoved);
        }
        int[] cMax = new int[4];
        ArrayList<String[]> rows = new ArrayList<String[]>(4);
        for (int i = 3; i >= 0; --i) {
            if (comp.numCases[i] == 0 && comp.removedTotal[i] == 0) continue;
            Object summary = "";
            if (comp.improvedStats[i] > 0) {
                summary = "\ud83d\udfe9 " + comp.improvedStats[i] + " improved";
            }
            if (comp.regressedStats[i] > 0) {
                if (!((String)summary).isEmpty()) {
                    summary = (String)summary + " ";
                }
                summary = (String)summary + "\ud83d\udfe5 " + comp.regressedStats[i] + " regressed";
            }
            if (comp.newStats[i] > 0) {
                if (!((String)summary).isEmpty()) {
                    summary = (String)summary + " ";
                }
                summary = (String)summary + comp.newStats[i] + " new";
            }
            if (comp.removedStats[i] > 0) {
                if (!((String)summary).isEmpty()) {
                    summary = (String)summary + " ";
                }
                summary = (String)summary + comp.removedStats[i] + " removed";
            }
            String[] row = new String[]{TestCaseState.values()[i].humanName, ": " + comp.numCases[i], comp.addedTotal[i] != 0 || comp.removedTotal[i] != 0 ? "(+" + comp.addedTotal[i] + " -" + comp.removedTotal[i] + ")" : "", summary};
            for (int j = 0; j < 4; ++j) {
                cMax[j] = Math.max(cMax[j], row[j].length());
            }
            rows.add(row);
        }
        if (rows.isEmpty()) {
            if (lines.size() == 1) {
                return List.of();
            }
            lines.add("```");
            return lines;
        }
        for (String[] row : rows) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < row.length; ++i) {
                if (i > 1) {
                    line.append(" ");
                }
                line.append(StringUtils.rightPad((String)row[i], (int)cMax[i]));
            }
            lines.add(line.toString());
        }
        lines.add("```");
        return lines;
    }

    private String buildGistsFor(ArtifactVariant baseVariant, ArtifactVariant headVariant, Predicate<String> filter, String desc) throws IOException {
        return FastStream.of((Object[])new String[]{this.buildGistFor(baseVariant, headVariant, filter.and(e -> e.endsWith(".java")), desc, "java"), this.buildGistFor(baseVariant, headVariant, filter.and(e -> e.endsWith(".java.javac_log")), desc, "javac"), this.buildGistFor(baseVariant, headVariant, filter.and(e -> e.endsWith(".class.diff")), desc, "rt")}).filter(Objects::nonNull).join("/");
    }

    @Nullable
    private String buildGistFor(ArtifactVariant baseVariant, ArtifactVariant headVariant, Predicate<String> filter, String desc, String name) throws IOException {
        String diff = this.diffService.getDiff(this.artifactService.exportVariant(baseVariant, ArchiveFormat.TAR, filter), this.artifactService.exportVariant(headVariant, ArchiveFormat.TAR, filter), desc).getGist();
        if (diff == null) {
            return null;
        }
        return "[" + name + "](" + diff + ")";
    }
}

