/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.service;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.DiffOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.diffpatch.util.archiver.ArchiveReader;
import io.codechicken.diffpatch.util.archiver.ArchiveWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.javasauce.cibot.entity.Diff;
import net.javasauce.cibot.repo.DiffRepo;
import net.javasauce.cibot.service.ArtifactService;
import net.javasauce.cibot.service.GitHubService;
import net.javasauce.cibot.util.Archive;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DiffService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int UNIFIED_DIFF_THRESHOLD = 50;
    public final ArtifactService artifactService;
    public final GitHubService gitHubService;
    public final DiffRepo diffRepo;

    public DiffService(ArtifactService artifactService, GitHubService gitHubService, DiffRepo diffRepo) {
        this.artifactService = artifactService;
        this.gitHubService = gitHubService;
        this.diffRepo = diffRepo;
    }

    public Diff getDiff(Archive left, Archive right, String desc) throws IOException {
        LOGGER.info("Generating diff..");
        String leftHash = left.hashFiles();
        String rightHash = right.hashFiles();
        Diff diff = this.diffRepo.findByLeftHashAndRightHash(leftHash, rightHash);
        if (diff != null) {
            LOGGER.info(" Diff already exists!");
            return diff;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DiffOperation diffOp = DiffOperation.builder().baseInput((Input)Input.MultiInput.archive((ArchiveFormat)left.format(), (byte[])left.bytes())).changedInput((Input)Input.MultiInput.archive((ArchiveFormat)right.format(), (byte[])right.bytes())).patchesOutput((Output)Output.MultiOutput.archive((ArchiveFormat)ArchiveFormat.TAR, (OutputStream)bos)).build();
        CliOperation.Result result = diffOp.operate();
        DiffOperation.DiffSummary summary = (DiffOperation.DiffSummary)result.summary;
        if (summary == null) {
            throw new IllegalStateException("Diff operation did not succeed. Exit: " + result.exit);
        }
        Archive unifiedDiff = this.makeUnifiedDiff(new Archive(bos.toByteArray(), ArchiveFormat.TAR));
        String gist = this.gitHubService.createGist(unifiedDiff, desc);
        diff = new Diff(leftHash, rightHash, gist, summary);
        this.diffRepo.save((Object)diff);
        return diff;
    }

    public Archive makeUnifiedDiff(Archive archive) throws IOException {
        try (ArchiveReader reader = archive.open();){
            if (reader.getEntries().size() <= 50) {
                Archive archive2 = archive;
                return archive2;
            }
            ByteArrayOutputStream unifiedBOS = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(unifiedBOS, true);
            for (String entry : reader.getEntries()) {
                reader.readLines(entry).forEach(pw::println);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ArchiveWriter writer = ArchiveFormat.TAR.createWriter((OutputStream)bos);){
                writer.writeEntry("joined.patch", unifiedBOS.toByteArray());
            }
            Archive archive3 = new Archive(bos.toByteArray(), ArchiveFormat.TAR);
            return archive3;
        }
    }
}

