/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.controller;

import net.javasauce.cibot.data.ApiResponse;
import net.javasauce.cibot.service.ArtifactVariantMissingException;
import net.javasauce.cibot.util.AuthFailure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ErrorController {
    private static final Logger LOGGER = LogManager.getLogger();

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ApiResponse> noHandlerFound(NoHandlerFoundException ex) {
        return ApiResponse.badRequest((String)(ex.getHttpMethod() + " not supported for " + ex.getRequestURL()));
    }

    @ExceptionHandler
    public ResponseEntity<ApiResponse> mediaTypeNotSupported(HttpMediaTypeNotSupportedException ex) {
        return ApiResponse.badRequest((String)("Content-Type " + String.valueOf(ex.getContentType()) + " not supported."));
    }

    @ExceptionHandler
    public ResponseEntity<ApiResponse> authFailure(AuthFailure ex) {
        return ApiResponse.forbidden((String)("Failed to validate authentication. " + ex.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<ApiResponse> variantMissing(ArtifactVariantMissingException ex) {
        return ApiResponse.notFound((String)("Variant '" + ex.commit + "' of Artifact '" + ex.notation + "' does not exist."));
    }

    @ExceptionHandler
    public ResponseEntity<ApiResponse> fallbackHandler(Throwable ex) {
        LOGGER.error("Error handling request: {}", (Object)"", (Object)ex);
        return ApiResponse.internalError((String)("Internal error: " + ex.getMessage()));
    }
}

