/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.controller.v1;

import java.io.IOException;
import net.javasauce.cibot.data.ApiResponse;
import net.javasauce.cibot.service.ArtifactService;
import net.javasauce.cibot.service.AuthService;
import net.javasauce.cibot.service.BuildService;
import net.javasauce.cibot.util.TestCaseDef;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/v1/build"})
public class BuildController {
    private final AuthService authService;
    private final BuildService pushService;
    private final ArtifactService artifactService;

    public BuildController(AuthService authService, BuildService pushService, ArtifactService artifactService) {
        this.authService = authService;
        this.pushService = pushService;
        this.artifactService = artifactService;
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<ApiResponse> uploadArtifact(@RequestParam(value="notation") String notation, @RequestParam(value="head_commit") String headCommit, @RequestParam(value="run_id") long runId, @RequestParam(value="pr_id", required=false, defaultValue="-1") long prId, @RequestPart(value="output") MultipartFile output, @RequestPart(value="stats") TestCaseDef stats, @RequestPart(value="api_key") String apiKey) throws Throwable {
        this.authService.checkAuth(headCommit, runId, prId, apiKey);
        if (!"application/zip".equals(output.getContentType())) {
            return ApiResponse.badRequest((String)("Expected 'output' to be an application/zip. Got: " + output.getContentType()));
        }
        return this.artifactService.importVersion(notation, headCommit, output.getBytes(), stats);
    }

    @PostMapping(value={"post_update"}, consumes={"text/plain"})
    public ResponseEntity<ApiResponse> postUpdate(@RequestParam(value="base_commit") String baseCommit, @RequestParam(value="head_commit") String headCommit, @RequestParam(value="run_id") long runId, @RequestParam(value="pr_id", required=false, defaultValue="-1") long prId, @RequestBody String apiKey) throws IOException {
        this.authService.checkAuth(headCommit, runId, prId, apiKey);
        return this.pushService.postUpdate(baseCommit, headCommit, prId, apiKey);
    }
}

