/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.entity;

import io.codechicken.diffpatch.cli.DiffOperation;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.jetbrains.annotations.Nullable;

@Entity(name="diffs")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"leftHash", "rightHash"})})
public class Diff {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    private String leftHash;
    private String rightHash;
    @Nullable
    private String gist;
    private int unchangedFiles;
    private int addedFiles;
    private int changedFiles;
    private int removedFiles;
    private long addedLines;
    private long removedLines;

    protected Diff() {
    }

    public Diff(String leftHash, String rightHash, @Nullable String gist, DiffOperation.DiffSummary summary) {
        this.gist = gist;
        this.leftHash = leftHash;
        this.rightHash = rightHash;
        this.unchangedFiles = summary.unchangedFiles;
        this.addedFiles = summary.addedFiles;
        this.changedFiles = summary.changedFiles;
        this.removedFiles = summary.removedFiles;
        this.addedLines = summary.addedLines;
        this.removedLines = summary.removedLines;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getGist() {
        return this.gist;
    }

    public String getLeftHash() {
        return this.leftHash;
    }

    public String getRightHash() {
        return this.rightHash;
    }

    public int getUnchangedFiles() {
        return this.unchangedFiles;
    }

    public int getAddedFiles() {
        return this.addedFiles;
    }

    public int getChangedFiles() {
        return this.changedFiles;
    }

    public int getRemovedFiles() {
        return this.removedFiles;
    }

    public long getAddedLines() {
        return this.addedLines;
    }

    public long getRemovedLines() {
        return this.removedLines;
    }

    public void setGist(String gist) {
        this.gist = gist;
    }

    public void setLeftHash(String leftHash) {
        this.leftHash = leftHash;
    }

    public void setRightHash(String rightHash) {
        this.rightHash = rightHash;
    }

    public void setUnchangedFiles(int unChangedFiles) {
        this.unchangedFiles = unChangedFiles;
    }

    public void setAddedFiles(int addedFiles) {
        this.addedFiles = addedFiles;
    }

    public void setChangedFiles(int changedFiles) {
        this.changedFiles = changedFiles;
    }

    public void setRemovedFiles(int removedFiles) {
        this.removedFiles = removedFiles;
    }

    public void setAddedLines(long addedLines) {
        this.addedLines = addedLines;
    }

    public void setRemovedLines(long removedLines) {
        this.removedLines = removedLines;
    }
}

