/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.service;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.diffpatch.util.archiver.ArchiveReader;
import io.codechicken.diffpatch.util.archiver.ArchiveWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.IOUtils;
import net.javasauce.cibot.CIBotProperties;
import net.javasauce.cibot.data.ApiResponse;
import net.javasauce.cibot.data.VariantImportError;
import net.javasauce.cibot.entity.ArtifactVariant;
import net.javasauce.cibot.entity.FileObject;
import net.javasauce.cibot.entity.VersionFile;
import net.javasauce.cibot.repo.ArtifactVariantRepo;
import net.javasauce.cibot.repo.FileObjectRepo;
import net.javasauce.cibot.repo.VersionFileRepo;
import net.javasauce.cibot.util.Archive;
import net.javasauce.cibot.util.TestCaseDef;
import net.javasauce.cibot.util.TestCaseState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ArtifactService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashFunction SHA256 = Hashing.sha256();
    private final FileObjectRepo fileRepo;
    private final ArtifactVariantRepo variantRepo;
    private final VersionFileRepo vFileRepo;
    private final CIBotProperties props;

    public ArtifactService(FileObjectRepo fileRepo, ArtifactVariantRepo variantRepo, VersionFileRepo vFileRepo, CIBotProperties props) {
        this.fileRepo = fileRepo;
        this.variantRepo = variantRepo;
        this.vFileRepo = vFileRepo;
        this.props = props;
    }

    public ResponseEntity<ApiResponse> importVersion(String notation, String headCommit, byte[] zipFile, TestCaseDef stats) throws IOException {
        LOGGER.info("Importing {} for commit {}.", (Object)notation, (Object)headCommit);
        ArtifactVariant variant = this.variantRepo.findByNotationAndCommit(notation, headCommit);
        if (variant == null) {
            List files = this.importVariant(zipFile);
            HashMap cases = FastStream.of(stats.cases.entrySet()).toMap(Map.Entry::getKey, e -> ((TestCaseDef.Case)e.getValue()).broken != null ? TestCaseState.BROKEN : ((TestCaseDef.Case)e.getValue()).target);
            variant = new ArtifactVariant(notation, headCommit, files, (Map)cases);
            this.variantRepo.save((Object)variant);
        } else {
            LOGGER.info("Version already exists. Validating..");
            List errors = this.validateVariant(variant, zipFile);
            if (!errors.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)new VariantImportError(errors));
            }
        }
        return ApiResponse.ok();
    }

    private List<VersionFile> importVariant(byte[] zipFile) throws IOException {
        HashMap<String, FileObject> newFileObjects = new HashMap<String, FileObject>();
        LinkedList<VersionFile> newVFiles = new LinkedList<VersionFile>();
        LinkedList<VersionFile> files = new LinkedList<VersionFile>();
        try (ArchiveReader ar = ArchiveFormat.ZIP.createReader((InputStream)new ByteArrayInputStream(zipFile));){
            for (String entry : ar.getEntries()) {
                VersionFile vFile;
                boolean fileInRepo;
                byte[] bytes = ar.getBytes(entry);
                String hash = SHA256.hashBytes(bytes).toString();
                FileObject file = this.fileRepo.findByHash(hash);
                boolean bl = fileInRepo = file != null;
                if (file == null && (file = (FileObject)newFileObjects.get(hash)) != null) {
                    LOGGER.info("Using existing new FileObject {} for {}.", (Object)hash, (Object)entry);
                }
                if (file == null) {
                    file = new FileObject(hash, bytes.length);
                    newFileObjects.put(hash, file);
                    Files.write(IOUtils.makeParents((Path)this.getPathFor(hash)), bytes, new OpenOption[0]);
                } else if (file.getLen() != bytes.length) {
                    throw new IOException("CALL GHOST BUSTERS!, WE HAVE A SHA256 COLLISION!!! " + hash + " " + file.getLen() + " " + bytes.length);
                }
                VersionFile versionFile = vFile = fileInRepo ? this.vFileRepo.findByPathAndFile(entry, file) : null;
                if (vFile == null) {
                    vFile = new VersionFile(entry, file);
                    newVFiles.add(vFile);
                }
                files.add(vFile);
            }
        }
        this.fileRepo.saveAll(newFileObjects.values());
        this.vFileRepo.saveAll(newVFiles);
        return files;
    }

    private List<String> validateVariant(ArtifactVariant variant, byte[] zipFile) throws IOException {
        LinkedList<String> errors = new LinkedList<String>();
        HashSet files = new HashSet(variant.getFiles());
        try (ArchiveReader ar = ArchiveFormat.ZIP.createReader((InputStream)new ByteArrayInputStream(zipFile));){
            for (String entry : ar.getEntries()) {
                byte[] bytes = ar.getBytes(entry);
                String hash = SHA256.hashBytes(bytes).toString();
                FileObject file = this.fileRepo.findByHash(hash);
                if (file == null) {
                    errors.add("Missing file object %s.".formatted(hash));
                    continue;
                }
                if (file.getLen() != bytes.length) {
                    throw new IOException("CALL GHOST BUSTERS!, WE HAVE A SHA256 COLLISION!!! " + hash + " " + file.getLen() + " " + bytes.length);
                }
                VersionFile vFile = this.vFileRepo.findByPathAndFile(entry, file);
                if (vFile == null) {
                    errors.add("File '%s' with hash %s does not exist.".formatted(entry, hash));
                    continue;
                }
                if (files.remove(vFile)) continue;
                errors.add("File '%s' with hash %s does not belong in this variant.".formatted(entry, hash));
            }
            for (VersionFile file : files) {
                errors.add("File '%s' with hash %s is required for this variant.".formatted(file.getPath(), file.getFile().getHash()));
            }
        }
        return errors;
    }

    public Archive exportVariant(ArtifactVariant variant, ArchiveFormat format, @Nullable Predicate<String> filter) throws IOException {
        LOGGER.info("Exporting variant {} of {}", (Object)variant.getCommit(), (Object)variant.getNotation());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ArchiveWriter aw = format.createWriter((OutputStream)bos);){
            for (VersionFile file : variant.getFiles()) {
                if (filter != null && !filter.test(file.getPath())) continue;
                aw.writeEntry(file.getPath(), Files.readAllBytes(this.getPathFor(file.getFile().getHash())));
            }
        }
        return new Archive(bos.toByteArray(), format);
    }

    public Path getPathFor(String hash) {
        String a = hash.substring(0, 2);
        String b = hash.substring(2, 4);
        return this.props.getObjectsDir().resolve(a).resolve(b).resolve(hash);
    }
}

