/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.cibot.service;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.codechicken.diffpatch.util.archiver.ArchiveReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import net.javasauce.cibot.CIBotProperties;
import net.javasauce.cibot.service.GitHubService;
import net.javasauce.cibot.util.Archive;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
public class GitHubService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().build();
    private final Gson gson = new Gson();
    private final CIBotProperties props;

    public GitHubService(CIBotProperties props) {
        this.props = props;
    }

    @Nullable
    public String createGist(Archive archive, String desc) throws IOException {
        try (ArchiveReader ar = archive.format().createReader((InputStream)new ByteArrayInputStream(archive.bytes()));){
            Object object;
            LinkedHashMap<String, FileContent> files = new LinkedHashMap<String, FileContent>();
            for (String entry : ar.getEntries()) {
                files.put(entry.replace('/', '_'), new FileContent(new String(ar.getBytes(entry), StandardCharsets.UTF_8)));
            }
            if (files.isEmpty()) {
                object = null;
                return object;
            }
            object = this.uploadGist(new GistCreateRequest(desc, false, files));
            return object;
        }
    }

    public long addComment(long issue, String apiKey, String content) throws IOException {
        JsonObject reqBody = new JsonObject();
        reqBody.addProperty("body", content);
        Request.Builder request = new Request.Builder().url("https://api.github.com/repos/" + this.props.getGithubOwner() + "/" + this.props.getGithubRepo() + "/issues/" + issue + "/comments").header("Accept", "application/vnd.github+json").header("Authorization", "Bearer " + apiKey).post(RequestBody.create((byte[])reqBody.toString().getBytes(StandardCharsets.UTF_8)));
        try (Response response = HTTP_CLIENT.newCall(request.build()).execute();){
            long l;
            block14: {
                ResponseBody body = response.body();
                try {
                    if (response.code() != 201) {
                        String bodyStr = body != null ? body.string() : null;
                        throw new IllegalStateException("Unexpected response from Github API: " + response.code() + " " + bodyStr);
                    }
                    if (body == null) {
                        throw new IllegalStateException("Got 201 CREATED from Github. But no body?");
                    }
                    IssueCreateResponse resp = (IssueCreateResponse)this.gson.fromJson(body.string(), IssueCreateResponse.class);
                    l = resp.id;
                    if (body == null) break block14;
                }
                catch (Throwable throwable) {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                body.close();
            }
            return l;
        }
    }

    public void updateComment(long comment, String apiKey, String content) throws IOException {
        JsonObject reqBody = new JsonObject();
        reqBody.addProperty("body", content);
        Request.Builder request = new Request.Builder().url("https://api.github.com/repos/" + this.props.getGithubOwner() + "/" + this.props.getGithubRepo() + "/issues/comments/" + comment).header("Accept", "application/vnd.github+json").header("Authorization", "Bearer " + apiKey).patch(RequestBody.create((byte[])reqBody.toString().getBytes(StandardCharsets.UTF_8)));
        try (Response response = HTTP_CLIENT.newCall(request.build()).execute();
             ResponseBody body = response.body();){
            if (response.code() != 200) {
                String bodyStr = body != null ? body.string() : null;
                throw new IllegalStateException("Unexpected response from Github API: " + response.code() + " " + bodyStr);
            }
        }
    }

    private String uploadGist(GistCreateRequest requestBody) throws IOException {
        LOGGER.info("Uploading gist...");
        Request.Builder request = new Request.Builder().url("https://api.github.com/gists").header("Accept", "application/vnd.github+json").header("Authorization", "Bearer " + this.props.getGistToken()).post(RequestBody.create((String)this.gson.toJson((Object)requestBody), (MediaType)MediaType.get((String)"application/json")));
        try (Response response = HTTP_CLIENT.newCall(request.build()).execute();){
            String string;
            block14: {
                ResponseBody body = response.body();
                try {
                    if (response.code() != 201) {
                        String bodyStr = body != null ? body.string() : null;
                        throw new IllegalStateException("Unexpected response from Github API: " + response.code() + " " + bodyStr);
                    }
                    if (body == null) {
                        throw new IllegalStateException("Got 201 CREATED from Github. But no body?");
                    }
                    GistCreateResponse resp = (GistCreateResponse)this.gson.fromJson(body.string(), GistCreateResponse.class);
                    string = resp.htmlUrl;
                    if (body == null) break block14;
                }
                catch (Throwable throwable) {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                body.close();
            }
            return string;
        }
    }

    public WorkflowRun getWorkflowRun(long runId, String apiKey) throws IOException {
        Request.Builder request = new Request.Builder().get().url("https://api.github.com/repos/" + this.props.getGithubOwner() + "/" + this.props.getGithubRepo() + "/actions/runs/" + runId).header("Accept", "application/vnd.github+json").header("Authorization", "Bearer " + apiKey);
        try (Response response = HTTP_CLIENT.newCall(request.build()).execute();){
            WorkflowRun workflowRun;
            block14: {
                ResponseBody body = response.body();
                try {
                    String bodyStr;
                    String string = bodyStr = body != null ? body.string() : null;
                    if (response.code() != 200) {
                        throw new IllegalStateException("Unexpected response from Github API: " + response.code() + " " + bodyStr);
                    }
                    if (body == null) {
                        throw new IllegalStateException("Got 200 OK from Github. But no body?");
                    }
                    workflowRun = (WorkflowRun)this.gson.fromJson(bodyStr, WorkflowRun.class);
                    if (body == null) break block14;
                }
                catch (Throwable throwable) {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                body.close();
            }
            return workflowRun;
        }
    }
}

