/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.compilerserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.javasauce.compilerserver.Compiler;
import net.javasauce.compilerserver.packet.CompileRequestPacket;
import net.javasauce.compilerserver.packet.CompileResultPacket;

class RemoteCompilerObjectInputStream
extends ObjectInputStream {
    public final Set<String> allowedClasses = new HashSet<String>();
    public final List<String> allowedPackages = new ArrayList<String>();

    public RemoteCompilerObjectInputStream(InputStream is) throws IOException {
        super(is);
        this.allowedClasses.add("boolean");
        this.allowedClasses.add("byte");
        this.allowedClasses.add("char");
        this.allowedClasses.add("short");
        this.allowedClasses.add("int");
        this.allowedClasses.add("long");
        this.allowedClasses.add("float");
        this.allowedClasses.add("double");
        this.allowedClasses.add("void");
        this.allowedPackages.add("java.util");
        this.allowedPackages.add("java.lang");
        this.addAllowedClass(URI.class);
        this.addAllowedClass(CompileRequestPacket.class);
        this.addAllowedClass(CompileResultPacket.class);
        this.addAllowedClass(Compiler.CompileResult.class);
    }

    public void addAllowedClass(Class<?> clazz) {
        this.allowedClasses.add(clazz.getName());
    }

    private boolean isTypeAllowed(String type) {
        if (this.allowedClasses.contains(type)) {
            return true;
        }
        if (type.charAt(0) == 'L' && type.charAt(type.length() - 1) == ';') {
            return this.isTypeAllowed(type.substring(1, type.length() - 1));
        }
        if (type.charAt(0) == '[') {
            if (type.length() == 2) {
                return true;
            }
            return this.isTypeAllowed(type.substring(1));
        }
        for (String allowedPackage : this.allowedPackages) {
            if (!type.startsWith(allowedPackage + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (!this.isTypeAllowed(desc.getName())) {
            throw new ClassNotFoundException("Class " + desc.getName() + " is not allowed to be deserialized.");
        }
        return super.resolveClass(desc);
    }
}

