/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.compilerserver;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.WriteAbortedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.javasauce.compilerserver.Compiler;
import net.javasauce.compilerserver.RemoteCompilerObjectInputStream;
import net.javasauce.compilerserver.RemoteMain;
import net.javasauce.compilerserver.packet.CompileRequestPacket;
import net.javasauce.compilerserver.packet.CompileResultPacket;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteCompiler
implements Compiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCompiler.class);
    private static final String OVERRIDE_PATH = System.getProperty("net.javasauce.RemoteCompiler.jar_Path");
    private static final boolean DEBUG = Boolean.getBoolean("net.javasauce.RemoteCompiler.debug");
    private final Map<UUID, CompletableFuture<Compiler.CompileResult>> pending = new ConcurrentHashMap<UUID, CompletableFuture<Compiler.CompileResult>>();
    private final Process process;
    private final ObjectOutputStream out;
    private final RemoteCompilerObjectInputStream in;
    private final Thread readThread;
    private final Thread logThread;
    private boolean exitRequested;

    public RemoteCompiler(Path javaExecutable, List<String> jvmArgs, Collection<Path> compileClasspath) throws IOException {
        Path ourJarPath = RemoteCompiler.getOurPath();
        if (OVERRIDE_PATH != null) {
            ourJarPath = Paths.get(OVERRIDE_PATH, new String[0]);
        }
        if (ourJarPath == null) {
            throw new RuntimeException("Unable to locate our own jar on the classpath. Please ensure it not shadowed, or provide the 'net.javasauce.RemoteCompiler.jar_Path' sysprop");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(javaExecutable.toAbsolutePath().toString());
        if (DEBUG) {
            args.add("-Dnet.javasauce.RemoteCompiler.debug=true");
        }
        args.addAll(jvmArgs);
        args.add("-cp");
        args.add(ourJarPath.toAbsolutePath().toString());
        args.add(RemoteMain.class.getName());
        args.addAll(compileClasspath.stream().map(e -> e.toAbsolutePath().toString()).collect(Collectors.toList()));
        ProcessBuilder builder = new ProcessBuilder(args);
        LOGGER.info("Starting Java compiler on vm {}", (Object)javaExecutable.toAbsolutePath());
        this.process = builder.start();
        this.logThread = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LOGGER.info("CompilerServer: {}", (Object)line);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.logThread.setName("RemoteCompiler Log");
        this.logThread.setDaemon(true);
        this.logThread.start();
        LOGGER.info("RemoteCompiler started!");
        LOGGER.info("Negotiating..");
        this.in = new RemoteCompilerObjectInputStream(this.process.getInputStream());
        this.out = new ObjectOutputStream(this.process.getOutputStream());
        this.out.flush();
        this.readThread = new Thread(() -> {
            try {
                while (this.process.isAlive()) {
                    Object packet = this.in.readObject();
                    if (packet instanceof CompileResultPacket) {
                        this.handleCompileResult((CompileResultPacket)packet);
                        continue;
                    }
                    throw new RuntimeException("Unknown packet: " + packet.getClass().getName());
                }
            }
            catch (EOFException | WriteAbortedException ex) {
                if (this.exitRequested) {
                    return;
                }
                LOGGER.error("RemoteCompiler quit unexpectedly.");
                this.stop();
            }
            catch (Throwable ex) {
                if (this.exitRequested) {
                    return;
                }
                System.err.println("Error on read thread.");
                ex.printStackTrace(System.err);
                this.stop();
            }
        });
        this.readThread.setName("RemoteCompiler Read");
        this.readThread.setDaemon(true);
        this.readThread.start();
        LOGGER.info("Finished negotiating, ready.");
    }

    private synchronized void writePacket(Object obj) throws IOException {
        this.out.writeObject(obj);
        this.out.flush();
    }

    private void handleCompileResult(CompileResultPacket packet) {
        CompletableFuture<Compiler.CompileResult> result = this.pending.get(packet.id);
        if (result == null) {
            throw new RuntimeException("CompletableFuture has gone missing??");
        }
        result.complete(packet.result);
    }

    @Override
    public Compiler.CompileResult compile(URI sourceUri, String source, List<String> extraJavacArgs) {
        if (!this.process.isAlive()) {
            throw new RuntimeException("CompilerServer is dead.");
        }
        UUID id = UUID.randomUUID();
        CompletableFuture result = new CompletableFuture();
        this.pending.put(id, result);
        try {
            this.writePacket(new CompileRequestPacket(id, sourceUri, source, extraJavacArgs));
        }
        catch (IOException ex) {
            this.pending.remove(id);
            throw new RuntimeException("Failed to communicate with CompilerServer.", ex);
        }
        return (Compiler.CompileResult)result.join();
    }

    private void stop() {
        if (this.exitRequested) {
            return;
        }
        this.exitRequested = true;
        LOGGER.info("Stopping RemoteCompiler.");
        this.process.destroy();
        for (CompletableFuture<Compiler.CompileResult> value : this.pending.values()) {
            value.completeExceptionally(new RuntimeException("RemoteCompiler quit unexpectedly."));
        }
        try {
            this.process.waitFor();
            this.readThread.join();
            this.logThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for compiler and threads to stop.", e);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    @Nullable
    private static Path getOurPath() {
        ProtectionDomain dom = RemoteMain.class.getProtectionDomain();
        if (dom == null) {
            return null;
        }
        CodeSource src = dom.getCodeSource();
        if (src == null) {
            return null;
        }
        try {
            return Paths.get(src.getLocation().toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

