package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

/**
 * Created by covers1624 on 13/4/21.
 */
public abstract class Field {

    public abstract ClassType getDeclaringClass();

    public abstract String getName();

    public abstract AType getType();

    public abstract EnumBitSet<AccessFlag> getAccessFlags();

    public abstract Type getDescriptor();

    public AnnotationSupplier getAnnotationSupplier() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public abstract Object getConstantValue();

    public abstract Field asRaw();

    public final boolean isStatic() {
        return getAccessFlags().get(AccessFlag.STATIC);
    }

    public final boolean isSynthetic() {
        return getAccessFlags().get(AccessFlag.SYNTHETIC);
    }

    public String getFullName() {
        return getDeclaringClass().getFullName() + "." + getName();
    }

    public abstract Field getDeclaration();
}
