/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class InnerClasses
implements ClassTransformer {
    private ClassType outerType;

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        cInsn.getClassMembers().forEach(e -> this.processInnerClass((ClassDecl)e, ctx));
    }

    private void processInnerClass(ClassDecl cInsn, ClassTransformContext ctx) {
        if (cInsn.getClazz().isStatic()) {
            return;
        }
        ctx.pushStep("Remove synthetic Outer.this field");
        this.outerType = cInsn.getClazz().getEnclosingClass().orElseThrow(SneakyUtils.notPossible());
        FastStream constructors = cInsn.getMethodMembers().filter(f -> f.getMethod().isConstructor());
        Field thisField = (Field)constructors.map(this::matchOuterThisField).filter(Objects::nonNull).distinct().onlyOrDefault();
        assert (thisField == null || ((ClassType)thisField.getType()).getDeclaration() == this.outerType);
        assert (thisField == null || thisField.isSynthetic());
        constructors.forEach(this::removeOuterThisParam);
        if (thisField != null) {
            cInsn.descendantsMatching(e -> LoadStoreMatching.matchLoadField(e, thisField)).forEach(e -> e.replaceWith(new LoadThis(TypeSystem.makeThisType(this.outerType))));
            ((FieldDecl)cInsn.getFieldMembers().filter(f -> f.getField().equals(thisField)).only()).remove();
        }
        ctx.popStep();
    }

    private void removeOuterThisParam(MethodDecl constructor) {
        ParameterVariable thisParam = constructor.parameters.get(0);
        Store storeField = this.findOuterThisField(constructor, thisParam);
        if (storeField != null) {
            storeField.remove();
        }
        thisParam.makeImplicit();
        List.copyOf(thisParam.getReferences()).forEach(e -> ((Load)e.getParent()).replaceWith(new LoadThis(TypeSystem.makeThisType(this.outerType))));
    }

    @Nullable
    private Field matchOuterThisField(MethodDecl constructor) {
        ParameterVariable thisParam = constructor.parameters.get(0);
        assert (((ClassType)thisParam.getType()).getDeclaration() == this.outerType);
        Store storeField = this.findOuterThisField(constructor, thisParam);
        if (storeField == null) {
            return null;
        }
        FieldReference fieldRef = (FieldReference)storeField.getReference();
        assert (fieldRef.getTarget() instanceof LoadThis);
        assert (LoadStoreMatching.matchLoadLocal(storeField.getValue(), thisParam) != null);
        return fieldRef.getField();
    }

    @Nullable
    private Store findOuterThisField(MethodDecl ctor, LocalVariable thisParam) {
        Invoke delegateCall = InvokeMatching.findDelegatedCtor(ctor);
        assert (delegateCall != null);
        Store store = LoadStoreMatching.matchStoreField(delegateCall.getPrevSiblingOrNull());
        if (!(store instanceof Store)) {
            return null;
        }
        Store store2 = store;
        if (LoadStoreMatching.matchLoadLocal(store2.getValue(), thisParam) == null) {
            return null;
        }
        FieldReference fRef = (FieldReference)store2.getReference();
        assert (fRef.getTarget() instanceof LoadThis);
        assert (fRef.getField().isSynthetic());
        return store2;
    }
}

