package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

import static net.covers1624.coffeegrinder.bytecode.InstructionFlag.END_POINT_UNREACHABLE;
import static net.covers1624.coffeegrinder.bytecode.InstructionFlag.MAY_BRANCH;

/**
 * Created by covers1624 on 12/9/21.
 */
public final class Continue extends SimpleInstruction {

    private static final EnumBitSet<InstructionFlag> FLAGS = EnumBitSet.of(END_POINT_UNREACHABLE, MAY_BRANCH);

    private AbstractLoop loop;

    public Continue(AbstractLoop loop) {
        this.loop = loop;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return FLAGS;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitContinue(this, ctx);
    }

    public AbstractLoop getLoop() {
        return loop;
    }

    public void setLoop(AbstractLoop loop) {
        if (isConnected()) {
            this.loop.remContinue(this);
        }
        this.loop = loop;
        if (isConnected()) {
            this.loop.addContinue(this);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        loop.addContinue(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        loop.remContinue(this);
    }

    @Nullable
    public static Continue matchContinue(Instruction insn, AbstractLoop loop) {
        if (!(insn instanceof Continue c)) return null;
        if (c.getLoop() != loop) return null;
        return c;
    }
}
