/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Iterator;
import java.util.LinkedList;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ConditionDetection;

public class SwitchInlining
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        LinkedList<Switch> switches = function.descendantsToList(Switch.class);
        for (Switch aSwitch : switches) {
            BlockContainer switchContainer = aSwitch.getBody();
            ctx.pushStep("Inline switch sections " + switchContainer.getEntryPoint().getName());
            Iterator<SwitchTable.SwitchSection> iterator = aSwitch.getSwitchTable().sections.iterator();
            while (iterator.hasNext()) {
                Branch branch;
                Block target;
                SwitchTable.SwitchSection section = iterator.next();
                Instruction instruction = section.getBody();
                if (!(instruction instanceof Branch) || (target = (branch = (Branch)instruction).getTargetBlock()).getIncomingEdgeCount() != 1) continue;
                ctx.pushStep("Inline section");
                branch.replaceWith(target);
                ctx.popStep();
                Instruction instruction2 = section.getNextSiblingOrNull();
                if (instruction2 instanceof SwitchTable.SwitchSection) {
                    SwitchTable.SwitchSection nextSection = (SwitchTable.SwitchSection)instruction2;
                    if (target.instructions.count() > 1 && BranchLeaveMatching.compatibleExitInstruction(target.getLastChild(), nextSection.getBody())) {
                        ctx.pushStep("Create fallthrough");
                        target.getLastChild().remove();
                        ctx.popStep();
                        continue;
                    }
                }
                ConditionDetection.tryUnwrap(target, ctx);
            }
            ctx.popStep();
        }
    }
}

