package net.covers1624.coffeegrinder.type;

import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by covers1624 on 2/2/23.
 */
public class TypeAnnotationData {

    public static final TypeAnnotationData EMPTY = new TypeAnnotationData();
    static {
        EMPTY.outer = EMPTY;
    }

    private final @Nullable Target target;
    public final List<AnnotationData> annotations = new LinkedList<>();
    private TypeAnnotationData outer = EMPTY;
    private TypeAnnotationData[] children = new TypeAnnotationData[0];

    public TypeAnnotationData() {
        this(null);
    }

    public TypeAnnotationData(@Nullable Target target) {
        this.target = target;
    }

    public TypeAnnotationData getChild(int i) {
        return i < children.length ? children[i] : EMPTY;
    }

    public void setChild(int i, TypeAnnotationData child) {
        assert this != EMPTY : "Unable to set a child of empty";
        if (i >= children.length) {
            int prevLen = children.length;
            children = Arrays.copyOf(children, i + 1);
            Arrays.fill(children, prevLen, i + 1, EMPTY);
        }
        children[i] = child;
    }

    public TypeAnnotationData getLeftMost() {
        if (outer != EMPTY) {
            return outer; // TODO Test?
        }

        TypeAnnotationData child = getChild(0);
        if (child.target == Target.ARRAY_ELEMENT) {
            return child.getLeftMost();
        }

        return this;
    }

    public TypeAnnotationData step(Target target) {
        if (target == Target.OUTER_TYPE) return outer;

        return step(target, 0);
    }

    public TypeAnnotationData step(Target target, int index) {
        assert target != Target.OUTER_TYPE : "OUTER_TYPE is not applicable with an index.";

        TypeAnnotationData child = getChild(index);
        assert child == EMPTY || child.target == target : "Got: " + child.target + " expected: " + target;
        return child;
    }

    public TypeAnnotationData addStep(Target target) {
        if (target == Target.OUTER_TYPE) {
            if (outer == EMPTY) {
                outer = new TypeAnnotationData(target);
            }
            return outer;
        }
        return addStep(target, 0);
    }

    public TypeAnnotationData addStep(Target target, int index) {
        assert target != Target.OUTER_TYPE : "OUTER_TYPE is not applicable with an index.";

        TypeAnnotationData child = getChild(index);
        if (child == EMPTY) {
            child = new TypeAnnotationData(target);
            setChild(index, child);
        } else {
            assert child.target == target;
        }
        return child;
    }

    public boolean isEmpty() {
        return annotations.isEmpty() && children.length == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TypeAnnotationData that = (TypeAnnotationData) o;

        if (target != that.target) return false;
        if (!annotations.equals(that.annotations)) return false;
        return Arrays.equals(children, that.children);
    }

    public enum Target {
        ARRAY_ELEMENT,
        OUTER_TYPE,
        WILDCARD_BOUND,
        TYPE_ARGUMENT;
    }
}
