/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.util.resolver.FolderResolver;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class JRTResolver
implements Resolver {
    private final FileSystem fs;
    private final List<JRTModule> modules;

    public JRTResolver(Path javaHome) throws IOException {
        this.fs = FileSystems.newFileSystem(URI.create("jrt:///"), Map.of("java.home", javaHome.toAbsolutePath().normalize().toString()));
        try (Stream<Path> stream = Files.list(this.fs.getPath("/modules/", new String[0]));){
            this.modules = FastStream.of(stream).map(JRTModule::new).toImmutableList();
        }
    }

    @Override
    public FastStream<String> getAllClasses() {
        return FastStream.of(this.modules).flatMap(Resolver::getAllClasses);
    }

    @Override
    public FastStream<String> getAllResources() {
        return FastStream.of(this.modules).flatMap(Resolver::getAllResources);
    }

    @Override
    public byte @Nullable [] getResource(String name) throws IOException {
        for (JRTModule module : this.modules) {
            byte[] bytes = module.getResource(name);
            if (bytes == null) continue;
            return bytes;
        }
        return null;
    }

    @Override
    public boolean hasResource(String name) {
        for (JRTModule module : this.modules) {
            if (!module.hasResource(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    private static final class JRTModule
    extends FolderResolver {
        JRTModule(Path path) {
            super(path);
        }

        @Override
        public String toString() {
            return "JRTModule(" + String.valueOf(this.path) + ")";
        }
    }
}

