/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.ClassProcessor;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.debug.Debugger;
import net.covers1624.coffeegrinder.debug.NullStepper;
import net.covers1624.coffeegrinder.source.JavaSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.jvm.JVMUtils;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.io.IndentPrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoffeeGrinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoffeeGrinder.class);
    private static final IntSet KNOWN_SUPPORTED = IntArraySet.of((int[])new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17});

    public static void main(String[] args) throws Throwable {
        System.exit(CoffeeGrinder.mainI(args));
    }

    public static int mainI(String[] args) throws Throwable {
        Path astOutput;
        Path sourceOutput;
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help").forHelp();
        ArgumentAcceptingOptionSpec inputOpt = parser.acceptsAll(Arrays.asList("i", "input"), "Sets the input directory.").withRequiredArg().required().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec libsOpt = parser.acceptsAll(Arrays.asList("l", "lib"), "Specifies an optional library for context.").withRequiredArg().withValuesSeparatedBy(File.pathSeparatorChar).withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec jreRefOpt = parser.acceptsAll(Arrays.asList("j", "jreRef"), "Set to the Java executable of JRE to use as reference when decompiling. If not specified, uses the Decompilers JVM.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec debuggerOpt = parser.accepts("debugger", "Start an interactive http debugger server on the specified address + port.").withRequiredArg().defaultsTo((Object)"localhost:8081", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec outSourceOpt = parser.acceptsAll(Arrays.asList("o", "output"), "Specifies the location to dump output source files.").availableUnless((OptionSpec)debuggerOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec outAstOpt = parser.acceptsAll(Arrays.asList("a", "output-ast"), "Specifies the location to dump output AST files.").availableUnless((OptionSpec)debuggerOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec threadsOpt = parser.acceptsAll(Arrays.asList("t", "threads"), "Specifies the number of threads to use when decompiling. The default value will be the number of cores - 1. To disable threading set to 1.").availableUnless((OptionSpec)debuggerOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)(Runtime.getRuntime().availableProcessors() - 1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec reportOpt = parser.acceptsAll(Arrays.asList("r", "report"), "Prints a decompilation report to the specified path on disk.").availableUnless((OptionSpec)debuggerOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        OptionSet optSet = parser.parse(args);
        if (optSet.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.err);
            return -1;
        }
        Path inputPath = (Path)optSet.valueOf((OptionSpec)inputOpt);
        if (Files.notExists(inputPath, new LinkOption[0])) {
            LOGGER.error("Expected '--input' path to exist.");
            parser.printHelpOn((OutputStream)System.err);
            return -1;
        }
        ClassResolver classResolver = new ClassResolver();
        if (optSet.has((OptionSpec)jreRefOpt)) {
            JavaInstall javaInstall = JVMUtils.getJavaInstall((Path)optSet.valueOf((OptionSpec)jreRefOpt));
            classResolver.addResolvers(JVMUtils.getTargetJREClasspath(javaInstall));
        } else {
            classResolver.addResolvers(JVMUtils.getRuntimeJREClasspath());
        }
        classResolver.addResolvers(Resolver.findResolvers(optSet.valuesOf((OptionSpec)libsOpt)));
        classResolver.setTarget(inputPath);
        if (optSet.has((OptionSpec)debuggerOpt)) {
            if (Debugger.DEBUGGER == null) {
                LOGGER.error("Debugger is not available in this environment, please ensure it's included on the runtime classpath.");
                return -1;
            }
            Debugger.DEBUGGER.startDebugger((String)optSet.valueOf((OptionSpec)debuggerOpt), classResolver);
            return 0;
        }
        if (optSet.has((OptionSpec)outSourceOpt)) {
            sourceOutput = (Path)optSet.valueOf((OptionSpec)outSourceOpt);
            if (Files.exists(sourceOutput, new LinkOption[0]) && !Files.isDirectory(sourceOutput, new LinkOption[0])) {
                LOGGER.error("Expected '--output' to be a folder.");
                parser.printHelpOn((OutputStream)System.err);
                return -1;
            }
        } else {
            sourceOutput = null;
        }
        if (optSet.has((OptionSpec)outAstOpt)) {
            astOutput = (Path)optSet.valueOf((OptionSpec)outAstOpt);
            if (Files.exists(astOutput, new LinkOption[0]) && !Files.isDirectory(astOutput, new LinkOption[0])) {
                LOGGER.error("Expected '--output-ast' to be a folder.");
                parser.printHelpOn((OutputStream)System.err);
                return -1;
            }
        } else {
            astOutput = null;
        }
        if (sourceOutput == null && astOutput == null) {
            LOGGER.error("Expected '--output' or '--output-ast'.");
            return -1;
        }
        int threads = (Integer)optSet.valueOf((OptionSpec)threadsOpt);
        if (threads < 1) {
            LOGGER.error("Expected '--threads' value to be greater than 1.");
            parser.printHelpOn((OutputStream)System.err);
            return -1;
        }
        TypeResolver typeResolver = new TypeResolver(classResolver);
        DecompilerSettings settings = new DecompilerSettings();
        Resolver resolver = classResolver.getTargetResolver();
        ExecutorService executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Decompile Thread %d").build());
        LinkedList classes = resolver.getAllClasses().toLinkedList();
        LOGGER.info("Decompiling {} classes.", (Object)classes.size());
        IntArraySet warnedUnsupportedClassVersions = new IntArraySet();
        long decompStart = System.nanoTime();
        List<Failure> failures = Collections.synchronizedList(new LinkedList());
        for (String clazz : classes) {
            ClassType clazzType;
            if (clazz.endsWith("module-info") || (clazzType = typeResolver.resolveClassDecl(clazz)).getDeclType() != ClassType.DeclType.TOP_LEVEL) continue;
            int classVersion = clazzType.getClassVersion().ordinal() + 1;
            if (!KNOWN_SUPPORTED.contains(classVersion) && warnedUnsupportedClassVersions.add(classVersion)) {
                LOGGER.warn("Found classes compiled for java {}, this version is not known to be supported yet. Things may break.", (Object)classVersion);
            }
            executor.submit(() -> {
                try {
                    ClassProcessor processor = new ClassProcessor(typeResolver, clazzType, settings);
                    ClassDecl decl = processor.process(NullStepper.INSTANCE);
                    if (astOutput != null) {
                        Path output = astOutput.resolve(clazz + ".ast");
                        Files.createDirectories(output.getParent(), new FileAttribute[0]);
                        Files.writeString(output, (CharSequence)decl.toString(), new OpenOption[0]);
                    }
                    if (sourceOutput != null) {
                        LineBuffer lines = decl.accept(new JavaSourceVisitor(typeResolver));
                        Path output = sourceOutput.resolve(clazz + ".java");
                        Files.createDirectories(output.getParent(), new FileAttribute[0]);
                        Files.writeString(output, (CharSequence)String.join((CharSequence)"\n", lines.lines), new OpenOption[0]);
                    }
                }
                catch (Throwable e) {
                    failures.add(new Failure(clazz, e));
                    LOGGER.error("Failed to decompile: {}", (Object)clazz, (Object)e);
                }
            });
        }
        executor.shutdown();
        while (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
            LOGGER.info("Waiting for tasks...");
        }
        long decompDuration = System.nanoTime() - decompStart;
        LOGGER.info("Finished. Took {}", (Object)CoffeeGrinder.formatDuration(decompDuration));
        String failureReport = CoffeeGrinder.buildFailureReport(failures);
        if (!failureReport.isEmpty()) {
            LOGGER.error("\n{}", (Object)failureReport);
        }
        if (optSet.has((OptionSpec)reportOpt)) {
            try (PrintWriter pw = new PrintWriter((Writer)Files.newBufferedWriter(IOUtils.makeParents((Path)((Path)optSet.valueOf((OptionSpec)reportOpt))), new OpenOption[0]), true);){
                pw.printf("Decompiled %d classes in %s%n", classes.size(), CoffeeGrinder.formatDuration(decompDuration));
                if (!failureReport.isEmpty()) {
                    pw.println();
                    pw.println(failureReport);
                }
            }
        }
        return !failures.isEmpty() ? 1 : 0;
    }

    private static String buildFailureReport(List<Failure> failures) {
        if (failures.isEmpty()) {
            return "";
        }
        StringWriter failureReport = new StringWriter();
        IndentPrintWriter pw = new IndentPrintWriter(new PrintWriter((Writer)failureReport, true));
        pw.printf("### %d classes failed! ###%n", new Object[]{failures.size()});
        FastStream.of(failures).groupBy(e -> CoffeeGrinder.trimmedStackTrace(Objects.requireNonNull(e.ex), 7)).sorted(Comparator.comparingInt(e -> -e.count())).forEach(g -> {
            int count = g.count();
            pw.printf("%dx ", new Object[]{count});
            pw.println((String)g.getKey());
            g.limit(3).map(e -> e.clazz).forEach(x -> pw.printf("in %s%n", new Object[]{x}));
            if (count > 3) {
                pw.printf("in (%d more)%n", new Object[]{count - 3});
            }
            pw.println();
        });
        return failureReport.toString();
    }

    private static String formatDuration(long elapsedTimeInNs) {
        StringBuilder result = new StringBuilder();
        if (elapsedTimeInNs >= 3600000000000L) {
            result.append(elapsedTimeInNs / 3600000000000L).append("h ");
        }
        if (elapsedTimeInNs >= 60000000000L) {
            result.append(elapsedTimeInNs % 3600000000000L / 60000000000L).append("m ");
        }
        if (elapsedTimeInNs >= 1000000000L) {
            result.append(elapsedTimeInNs % 60000000000L / 1000000000L).append("s ");
        }
        if (elapsedTimeInNs < 1000000L) {
            return "< 1ms";
        }
        result.append(elapsedTimeInNs % 1000000000L / 1000000L).append("ms");
        return result.toString();
    }

    private static String trimmedStackTrace(Throwable ex, int nLines) {
        StackTraceElement[] trace = ex.getStackTrace();
        StringBuilder builder = new StringBuilder();
        builder.append(ex.getClass().getName()).append(" ").append(ex.getMessage());
        if (trace.length == 0) {
            builder.append(" No stack trace");
        } else {
            int numTrace = Math.min(nLines, trace.length);
            for (int i = 0; i < numTrace; ++i) {
                builder.append("\n\tat ").append(trace[i]);
            }
        }
        return builder.toString();
    }

    private record Failure(String clazz, Throwable ex) {
    }
}

