/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.SemanticHelper;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public final class TryCatch
extends Instruction {
    public final InstructionCollection<Instruction> resources = new InstructionCollection(this);
    public final InstructionSlot<BlockContainer> tryBody = new InstructionSlot(this);
    public final InstructionCollection<TryCatchHandler> handlers = new InstructionCollection(this);
    private final InstructionSlot<Instruction> finallyBody = new InstructionSlot(this);

    public TryCatch(BlockContainer tryBody) {
        this.tryBody.set(tryBody);
        this.finallyBody.set(new Nop());
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        BlockContainer finBody;
        EnumBitSet<InstructionFlag> flags = this.getTryBody().getFlags().copy();
        Iterator<TryCatchHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            TryCatchHandler handler = iterator.next();
            flags = SemanticHelper.combineBranches(flags, handler.getFlags());
        }
        BlockContainer blockContainer = this.getFinallyBody();
        if (blockContainer instanceof BlockContainer && (finBody = blockContainer).getFlags().get(InstructionFlag.END_POINT_UNREACHABLE)) {
            flags.set(InstructionFlag.END_POINT_UNREACHABLE);
        }
        return flags;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTryCatch(this, ctx);
    }

    public BlockContainer getTryBody() {
        return this.tryBody.get();
    }

    public void setTryBody(BlockContainer tryBody) {
        this.tryBody.set(tryBody);
    }

    @Nullable
    public BlockContainer getFinallyBody() {
        BlockContainer cont;
        Instruction instruction = this.finallyBody.get();
        return instruction instanceof BlockContainer ? (cont = (BlockContainer)instruction) : null;
    }

    public void setFinallyBody(@Nullable BlockContainer finallyBody) {
        this.finallyBody.set(finallyBody != null ? finallyBody : new Nop());
    }

    public static final class TryCatchHandler
    extends Instruction {
        private final InstructionSlot<LocalReference> variable = new InstructionSlot(this);
        private final InstructionSlot<BlockContainer> body = new InstructionSlot(this);
        public boolean isUnprocessedFinally = false;

        public TryCatchHandler(BlockContainer body, LocalReference variable) {
            this.variable.set(variable);
            this.body.set(body);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitTryCatchHandler(this, ctx);
        }

        @Override
        protected void onChildModified() {
            super.onChildModified();
            if (this.isConnected()) {
                this.getVariable().setWrittenTo(true);
            }
        }

        @Override
        protected void onConnected() {
            super.onConnected();
            this.getVariable().setWrittenTo(true);
        }

        public LocalReference getVariable() {
            return this.variable.get();
        }

        public BlockContainer getBody() {
            return this.body.get();
        }

        public void setVariable(Store variable) {
            this.variable.set(variable);
        }

        public TryCatch getTry() {
            return (TryCatch)this.getParent();
        }
    }
}

