/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorEnter;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorExit;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Synchronized;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;

public class SynchronizedTransform
extends SimpleInsnVisitor<MethodTransformContext>
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(this, ctx);
    }

    @Override
    public None visitTryCatch(TryCatch tryCatch, MethodTransformContext ctx) {
        Instruction instruction;
        if (tryCatch.getFinallyBody() == null || !((instruction = tryCatch.getPrevSiblingOrNull()) instanceof MonitorEnter)) {
            return (None)super.visitTryCatch(tryCatch, ctx);
        }
        MonitorEnter monitor = (MonitorEnter)instruction;
        ctx.pushStep("Generate Synchronized");
        Store store = (Store)monitor.getArgument();
        Block finallyBody = tryCatch.getFinallyBody().getEntryPoint();
        MonitorExit monitorExit = (MonitorExit)finallyBody.getFirstChild();
        Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(monitorExit.getArgument(), store.getVariable()));
        Objects.requireNonNull(BranchLeaveMatching.matchLeave(monitorExit.getNextSibling(), tryCatch.getFinallyBody()));
        Synchronized sync = tryCatch.replaceWith((Synchronized)new Synchronized(store.getValue(), tryCatch.getTryBody()).withOffsets(tryCatch));
        assert (store.getVariable().getLoadCount() == 0);
        monitor.remove();
        ctx.popStep();
        sync.accept(this, ctx);
        return NONE;
    }
}

