/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.jvm;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.util.resolver.JRTResolver;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.utils.JavaPropExtractor;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class JVMUtils {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String JAVA_BOOT_CLASS_PATH = "sun.boot.class.path";

    public static List<Resolver> getRuntimeJREClasspath() {
        return JVMUtils.getJREClasspath(System.getProperty(JAVA_BOOT_CLASS_PATH), JVMUtils.tryGetSysProp("java.home"));
    }

    public static JavaInstall getJavaInstall(Path executable) {
        JavaInstall install = JavaInstall.parse((Path)executable);
        if (install == null) {
            throw new RuntimeException("Unable to find valid Java installation at the provided Java executable.");
        }
        return install;
    }

    public static List<Resolver> getTargetJREClasspath(JavaInstall javaInstall) {
        Map props = JavaPropExtractor.extractProperties((Path)JavaInstall.getJavaExecutable((Path)javaInstall.javaHome, (boolean)true), Collections.singletonList(JAVA_BOOT_CLASS_PATH));
        if (props == null) {
            throw new RuntimeException("Failed to extract java classpath information.");
        }
        return JVMUtils.getJREClasspath((String)props.get(JAVA_BOOT_CLASS_PATH), javaInstall.javaHome);
    }

    public static List<Resolver> getJREClasspath(@Nullable String bootClasspathProp, @Nullable Path javaHome) {
        List<Path> paths = JVMUtils.listProp(bootClasspathProp);
        if (paths != null) {
            return Resolver.findResolvers(paths);
        }
        if (javaHome == null) {
            throw new IllegalArgumentException("Unable to get classpath. Expected Boot Classpath or a Java Home.");
        }
        if (Files.notExists(javaHome, new LinkOption[0])) {
            throw new IllegalArgumentException("Unable to get classpath. Expected Java Home to exist.");
        }
        try {
            return List.of(new JRTResolver(javaHome));
        }
        catch (IOException ex) {
            IOException jrtException = ex;
            Path jmods = javaHome.resolve("jmods");
            if (Files.isDirectory(jmods, new LinkOption[0])) {
                return JVMUtils.loadJMods(jmods);
            }
            throw new IllegalArgumentException("Unable to get classpath. Java Home specified, but can't open a JRT FileSystem, or find any .jmod files.", jrtException);
        }
    }

    public static List<Resolver> getRuntimeClasspath() {
        List<Path> paths = JVMUtils.listSysProp(JAVA_CLASS_PATH);
        if (paths != null) {
            return Resolver.findResolvers(paths);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static List<Path> listSysProp(String sysProp) {
        return JVMUtils.listProp(System.getProperty(sysProp));
    }

    @Nullable
    private static List<Path> listProp(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return FastStream.of((Object[])value.split(File.pathSeparator)).distinct().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
    }

    @Nullable
    private static Path tryGetSysProp(String prop) {
        String value = System.getProperty(prop);
        if (value == null) {
            return null;
        }
        return Path.of(value, new String[0]);
    }

    private static List<Resolver> loadJMods(Path jmodsFolder) {
        ImmutableList immutableList;
        block8: {
            Stream<Path> files = Files.list(jmodsFolder);
            try {
                immutableList = FastStream.of(files).map(Resolver::findResolver).toImmutableList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to list jmods directory.");
                }
            }
            files.close();
        }
        return immutableList;
    }
}

