/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.util;

import java.util.concurrent.Callable;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class SneakyUtils {
    private static final Runnable NULL_RUNNABLE = () -> {};
    private static final Callable<Object> NULL_CALLABLE = () -> null;
    private static final Supplier<Object> NULL_SUPPLIER = () -> null;
    private static final Consumer<Object> NULL_CONSUMER = e -> {};
    private static final Predicate<Object> TRUE = e -> true;
    private static final Predicate<Object> FALSE = e -> false;
    private static final BinaryOperator<Object> FIRST = (a, b) -> a;
    private static final BinaryOperator<Object> LAST = (a, b) -> b;
    private static final Supplier<NotPossibleException> NOT_POSSIBLE = () -> NotPossibleException.INSTANCE;

    public static Runnable none() {
        return NULL_RUNNABLE;
    }

    public static <T> Callable<T> nullC() {
        return (Callable)SneakyUtils.unsafeCast(NULL_CALLABLE);
    }

    public static <T> Supplier<T> nullS() {
        return (Supplier)SneakyUtils.unsafeCast(NULL_SUPPLIER);
    }

    public static <T> Consumer<T> nullCons() {
        return (Consumer)SneakyUtils.unsafeCast(NULL_CONSUMER);
    }

    public static <T> Predicate<T> trueP() {
        return (Predicate)SneakyUtils.unsafeCast(TRUE);
    }

    public static <T> Predicate<T> falseP() {
        return (Predicate)SneakyUtils.unsafeCast(FALSE);
    }

    public static <T> BinaryOperator<T> first() {
        return (BinaryOperator)SneakyUtils.unsafeCast(FIRST);
    }

    public static <T> BinaryOperator<T> last() {
        return (BinaryOperator)SneakyUtils.unsafeCast(LAST);
    }

    public static Runnable concat(Runnable a, Runnable b) {
        return () -> {
            a.run();
            b.run();
        };
    }

    public static Supplier<NotPossibleException> notPossible() {
        return NOT_POSSIBLE;
    }

    public static void sneaky(ThrowingRunnable<Throwable> tr) {
        try {
            tr.run();
        }
        catch (Throwable ex) {
            SneakyUtils.throwUnchecked(ex);
        }
    }

    public static Runnable sneak(ThrowingRunnable<Throwable> tr) {
        return () -> SneakyUtils.sneaky(tr);
    }

    public static <T> Consumer<T> sneak(ThrowingConsumer<T, Throwable> cons) {
        return e -> {
            try {
                cons.accept(e);
            }
            catch (Throwable ex) {
                SneakyUtils.throwUnchecked(ex);
            }
        };
    }

    public static <T> T sneaky(ThrowingSupplier<T, Throwable> sup) {
        try {
            return sup.get();
        }
        catch (Throwable ex) {
            SneakyUtils.throwUnchecked(ex);
            return null;
        }
    }

    public static <T> Supplier<T> sneak(ThrowingSupplier<T, Throwable> sup) {
        return () -> SneakyUtils.sneaky(sup);
    }

    public static <T, R> Function<T, R> sneak(ThrowingFunction<T, R, Throwable> tf) {
        return e -> {
            try {
                return tf.apply(e);
            }
            catch (Throwable ex) {
                SneakyUtils.throwUnchecked(ex);
                return null;
            }
        };
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static <T> T unsafeCast(@Nullable Object object) {
        return (T)object;
    }

    public static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw (Throwable)SneakyUtils.unsafeCast(t);
    }

    public static class NotPossibleException
    extends RuntimeException {
        public static NotPossibleException INSTANCE = new NotPossibleException();

        private NotPossibleException() {
        }

        public NotPossibleException(String message) {
            super(message);
        }
    }

    public static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    public static interface ThrowingSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    public static interface ThrowingRunnable<E extends Throwable> {
        public void run() throws E;
    }
}

