package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 16/7/21.
 */
public final class InvokeDynamic extends Instruction {

    private final AType resultType;
    public final String name;
    public final AType[] descriptorArgs;
    public final Method bootstrapHandle;
    public final Object[] bootstrapArguments;

    public final IndexedInstructionCollection<Instruction> arguments = new IndexedInstructionCollection<>(this);

    public InvokeDynamic(AType resultType, String name, AType[] descriptorArgs, Method bootstrapHandle, Object[] bootstrapArguments, Iterable<Instruction> arguments) {
        this.resultType = resultType;
        this.name = name;
        this.descriptorArgs = descriptorArgs;
        this.bootstrapHandle = bootstrapHandle;
        this.bootstrapArguments = bootstrapArguments;

        this.arguments.setValues(arguments);
    }

    @Override
    public AType getResultType() {
        return resultType;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitInvokeDynamic(this, ctx);
    }
}
