package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 28/2/21.
 */
public final class Load extends SimpleInstruction {

    private final InstructionSlot<Reference> reference = new InstructionSlot<>(this);

    // If this field is the first in the pair of loads from a DUP
    public boolean dup;

    @Nullable
    private AType cachedReferenceType;
    @Nullable
    private AType resultType;

    public Load(Reference reference) {
        this.reference.set(reference);
    }

    @Override
    public AType getResultType() {
        AType type = getReference().getType();
        if (!type.equals(cachedReferenceType)) {
            cachedReferenceType = type;
            resultType = TypeSystem.capture(cachedReferenceType);
        }

        assert resultType != null;
        return resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLoad(this, ctx);
    }

    @Override
    public Load copy() {
        return new Load(getReference().copy());
    }

    public Reference getReference() {
        return reference.get();
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (isConnected()) {
            getReference().setReadFrom(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        getReference().setReadFrom(true);
    }

    public LocalVariable getVariable() {
        return ((LocalReference) getReference()).variable;
    }
}
