package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

/**
 * Created by covers1624 on 25/2/21.
 */
public final class Nop extends SimpleInstruction {

    public Nop() {
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public Instruction copy() {
        Nop nop = new Nop();
        nop.setTag(getTag());
        return nop;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitNop(this, ctx);
    }
}
