package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 11/10/25.
 */
public class BoxingMatching {

    @Nullable
    public static Invoke matchBoxing(@Nullable Instruction insn) {
        if (!(insn instanceof Invoke invoke)) return null;

        var boxedType = invoke.getTargetClassType();
        var unboxedType = TypeSystem.unbox(boxedType);
        if (unboxedType == null) return null;

        var method = invoke.getMethod();
        if (!method.getName().equals(unboxedType.getBoxMethodName())) return null;

        var methodSingleParamType = FastStream.of(method.getParameters())
                .map(Parameter::getType)
                .onlyOrDefault();
        if (!unboxedType.equals(methodSingleParamType)) return null;
        if (!method.getReturnType().equals(boxedType)) return null;

        return invoke;
    }

    @Nullable
    public static Invoke matchUnboxing(@Nullable Instruction insn) {
        if (!(insn instanceof Invoke invoke)) return null;

        var unboxedType = TypeSystem.unbox(invoke.getTargetClassType());
        if (unboxedType == null) return null;

        var method = invoke.getMethod();
        if (!method.getParameters().isEmpty()) return null;
        if (method.getReturnType() != unboxedType) return null;
        if (!method.getName().equals(unboxedType.getUnboxMethodName())) return null;

        return invoke;
    }
}
