/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.flow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.flow.Dominance;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.util.None;

public class ControlFlowGraph {
    public final BlockContainer container;
    public final ControlFlowNode[] cfg;
    public final Map<Block, ControlFlowNode> nodes = new HashMap<Block, ControlFlowNode>();
    public final BitSet directExits;
    public final BitSet reachableExits;

    public ControlFlowGraph(BlockContainer container) {
        this.container = container;
        ArrayList blocks = container.blocks.toList();
        this.cfg = new ControlFlowNode[blocks.size()];
        this.directExits = new BitSet(this.cfg.length);
        this.reachableExits = new BitSet(this.cfg.length);
        for (int i = 0; i < this.cfg.length; ++i) {
            Block block = (Block)blocks.get(i);
            this.cfg[i] = new ControlFlowNode(i, block);
            this.nodes.put(block, this.cfg[i]);
        }
        this.createEdges(blocks);
        Dominance.computeDominance(this.cfg[0]);
        Dominance.computeReachableExits(this.reachableExits, this.cfg);
        this.computeExits();
    }

    private void createEdges(List<Block> blocks) {
        int i = 0;
        while (i < blocks.size()) {
            final Block block = blocks.get(i);
            final ControlFlowNode sourceNode = this.cfg[i];
            final int finalI = i++;
            block.accept(new SimpleInsnVisitor<None>(){

                @Override
                public None visitBranch(Branch branch, None ctx) {
                    if (branch.getTargetBlock().getParentOrNull() == ControlFlowGraph.this.container) {
                        sourceNode.addEdgeTo(ControlFlowGraph.this.nodes.get(branch.getTargetBlock()));
                    } else if (!branch.getTargetBlock().isDescendantOf(ControlFlowGraph.this.container)) {
                        ControlFlowGraph.this.directExits.set(finalI);
                    }
                    return (None)super.visitBranch(branch, ctx);
                }

                @Override
                public None visitLeave(Leave leave, None ctx) {
                    if (!leave.getTargetContainer().isDescendantOf(block)) {
                        ControlFlowGraph.this.directExits.set(finalI);
                    }
                    return (None)super.visitLeave(leave, ctx);
                }
            });
        }
    }

    private void computeExits() {
        BitSet leaving = new BitSet(this.cfg.length);
        for (ControlFlowNode node : this.cfg) {
            if (leaving.get(node.cfgIndex) || !this.directExits.get(node.cfgIndex)) continue;
            ControlFlowNode p = node;
            while (p != null && !leaving.get(p.cfgIndex)) {
                leaving.set(p.cfgIndex);
                p = p.immediateDominator;
            }
        }
        this.reachableExits.or(leaving);
    }

    public ControlFlowNode getNode(Block block) {
        return Objects.requireNonNull(this.nodes.get(block));
    }

    public boolean hasReachableExit(ControlFlowNode node) {
        assert (this.cfg[node.cfgIndex] == node);
        return this.reachableExits.get(node.cfgIndex);
    }

    public boolean hasDirectExit(ControlFlowNode node) {
        assert (this.cfg[node.cfgIndex] == node);
        return this.directExits.get(node.cfgIndex);
    }

    public void resetVisited() {
        for (ControlFlowNode node : this.cfg) {
            node.visited = false;
        }
    }

    public boolean dominates(ControlFlowNode head, Instruction insn) {
        if (!insn.isDescendantOf(this.container)) {
            return false;
        }
        ControlFlowNode node = (ControlFlowNode)insn.ancestorsOfType(Block.class).map(this.nodes::get).filterNot(Objects::isNull).first();
        return head.dominates(node);
    }
}

