/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.BitSet;
import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public final class SwitchTable
extends Instruction {
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);
    public final InstructionCollection<SwitchSection> sections = new InstructionCollection(this);
    @Nullable
    public final TableInfo tableInfo;

    public SwitchTable(Instruction value, @Nullable TableInfo tableInfo) {
        this.value.set(value);
        this.tableInfo = tableInfo;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        Object flags = this.getDirectFlags().copy();
        Iterator<SwitchSection> iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            SwitchSection section = iterator.next();
            ((BitSet)flags).or(section.getFlags());
        }
        ((BitSet)flags).or(this.value.get().getFlags());
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitSwitchTable(this, ctx);
    }

    public Instruction getValue() {
        return this.value.get();
    }

    public void setValue(Instruction value) {
        this.value.set(value);
    }

    public boolean isExhaustive() {
        return this.sections.anyMatch(section -> section.values.anyMatch(e -> e instanceof Nop));
    }

    public record TableInfo(int min, int max) {
    }

    public static final class SwitchSection
    extends Instruction {
        public final InstructionCollection<Instruction> values = new InstructionCollection(this);
        private final InstructionSlot<Instruction> body = new InstructionSlot(this);
        public boolean explicitBlock;

        public SwitchSection(Instruction body) {
            this.body.set(body);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitSwitchSection(this, ctx);
        }

        public Instruction getBody() {
            return this.body.get();
        }

        public void setBody(Instruction body) {
            this.body.set(body);
        }
    }

    public static class SwitchPattern
    extends Instruction {
        private final InstructionSlot<LocalReference> reference = new InstructionSlot(this);
        private final InstructionSlot<Instruction> condition = new InstructionSlot(this);

        public SwitchPattern(LocalReference reference) {
            this(reference, new Nop());
        }

        public SwitchPattern(LocalReference reference, Instruction condition) {
            this.reference.set(reference);
            this.condition.set(condition);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitSwitchPattern(this, ctx);
        }

        @Override
        protected void onChildModified() {
            super.onChildModified();
            if (this.isConnected()) {
                this.getReference().setWrittenTo(true);
            }
        }

        @Override
        protected void onConnected() {
            super.onConnected();
            this.getReference().setWrittenTo(true);
        }

        public LocalReference getReference() {
            return this.reference.get();
        }

        public Instruction getCondition() {
            return this.condition.get();
        }
    }
}

