/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.LogicOr;
import net.covers1624.coffeegrinder.bytecode.insns.Yield;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;

public class BooleanLogicYields
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Yield falseYield;
        Yield trueYield;
        IfInstruction ifInsn;
        IfInstruction ifInstruction = IfMatching.matchNopFalseIf(statement);
        if (!(ifInstruction instanceof IfInstruction) || !BooleanLogicYields.isBooleanLogic((ifInsn = ifInstruction).getCondition())) {
            return;
        }
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Yield) || LdcMatching.matchLdcBoolean((trueYield = (Yield)instruction).getValue(), true) == null) {
            return;
        }
        Instruction instruction2 = ifInsn.getNextSiblingOrNull();
        if (!(instruction2 instanceof Yield) || LdcMatching.matchLdcBoolean((falseYield = (Yield)instruction2).getValue(), false) == null) {
            return;
        }
        ctx.pushStep("Simplify boolean yield");
        statement.replaceWith(new Yield(trueYield.getSwitch(), ifInsn.getCondition()));
        falseYield.remove();
        ctx.popStep();
    }

    private static boolean isBooleanLogic(Instruction insn) {
        return insn instanceof Comparison || insn instanceof Binary || insn instanceof LogicOr || insn instanceof LogicAnd || insn instanceof LogicNot;
    }
}

