/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class SwitchOnType
implements StatementTransformer {
    private final ClassType string;
    @Nullable
    private final ClassType switchBootstraps;
    @Nullable
    private final ClassType matchException;

    public SwitchOnType(TypeResolver resolver) {
        this.string = resolver.resolveClass(String.class);
        this.switchBootstraps = resolver.tryResolveClassDecl("java/lang/runtime/SwitchBootstraps");
        this.matchException = resolver.tryResolveClassDecl("java/lang/MatchException");
    }

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Switch basicSwitch;
        if (this.switchBootstraps == null) {
            return;
        }
        Store valueStore = LoadStoreMatching.matchStoreLocal(statement);
        if (valueStore == null) {
            return;
        }
        LocalVariable valueVar = valueStore.getVariable();
        Store startFromStore = LoadStoreMatching.matchStoreLocal(valueStore.getNextSiblingOrNull());
        if (startFromStore == null) {
            return;
        }
        LocalVariable startFromVar = startFromStore.getVariable();
        if (LdcMatching.matchLdcInt(startFromStore.getValue(), 0) == null) {
            return;
        }
        WhileLoop loop = null;
        Instruction instruction = startFromStore.getNextSiblingOrNull();
        if (instruction instanceof WhileLoop) {
            WhileLoop llp = (WhileLoop)instruction;
            loop = llp;
            if (LdcMatching.matchLdcBoolean(loop.getCondition(), true) == null) {
                return;
            }
            basicSwitch = this.matchPatternSwitchDecl(loop.getBody().getEntryPoint().getFirstChild(), valueVar, startFromVar);
        } else {
            Instruction next = startFromStore.getNextSiblingOrNull();
            basicSwitch = this.matchPatternSwitchDecl(next, valueVar, startFromVar);
        }
        if (basicSwitch == null) {
            return;
        }
        InvokeDynamic indy = (InvokeDynamic)basicSwitch.getValue();
        ClassType indyEnumType = indy.bootstrapHandle.getName().equals("enumSwitch") ? (ClassType)indy.descriptorArgs[0] : null;
        ctx.pushStep("Produce pattern matching switch");
        Iterator<SwitchTable.SwitchSection> iterator = basicSwitch.getSwitchTable().sections.iterator();
        while (iterator.hasNext()) {
            SwitchTable.SwitchSection section = iterator.next();
            Iterator<Instruction> iterator2 = section.values.iterator();
            while (iterator2.hasNext()) {
                Instruction value = iterator2.next();
                if (value instanceof Nop) {
                    ctx.pushStep("Try capture unconditional default pattern");
                    this.tryCapturePatternVariable(valueVar, value, section, null, ctx);
                    ctx.popStep();
                    continue;
                }
                int idx = ((LdcNumber)value).getValue().intValue();
                ctx.pushStep("Rewrite case " + idx);
                this.rewriteSwitchCase(loop, indyEnumType, valueVar, startFromVar, section, indy, idx, value, ctx);
                ctx.popStep();
            }
        }
        assert (valueVar.getLoadCount() == 1 && valueVar.getStoreCount() == 1);
        assert (startFromVar.getLoadCount() == 1 && startFromVar.getStoreCount() == 1);
        if (loop != null) {
            BlockContainer body = loop.getBody();
            assert (loop.getContinues().isEmpty());
            assert (body.getEntryPoint().getIncomingEdgeCount() == 1);
            assert (body.getFirstChild() == body.getLastChild());
            assert (body.getLeaveCount() == 1);
            assert (BranchLeaveMatching.matchLeave(body.getEntryPoint().getLastChild(), body) != null);
            ctx.pushStep("Remove redundant loop");
            loop.replaceWith(body.getEntryPoint().getFirstChild());
            ctx.popStep();
        }
        basicSwitch.getValue().replaceWith(valueStore.getValue());
        startFromStore.remove();
        valueStore.remove();
        this.cleanupRedundantMatchException(basicSwitch, ctx);
        ctx.popStep();
    }

    private void rewriteSwitchCase(@Nullable WhileLoop loop, @Nullable ClassType indyEnumType, LocalVariable valueVar, LocalVariable startFromVar, SwitchTable.SwitchSection section, InvokeDynamic indy, int idx, Instruction value, StatementTransformContext ctx) {
        if (idx == -1) {
            value.replaceWith(new LdcNull());
            return;
        }
        Object indyArg = indy.bootstrapArguments[idx];
        if (indyEnumType != null) {
            assert (indyArg instanceof String);
            Field enumField = (Field)FastStream.of(indyEnumType.getFields()).filter(e -> e.getAccessFlags().get(AccessFlag.ENUM) && e.getName().equals(indyArg)).only();
            value.replaceWith(new FieldReference(enumField));
            return;
        }
        Object object = indyArg;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Type.class, Field.class}, (Object)object, n)) {
            case 0: {
                String s = (String)object;
                value.replaceWith(new LdcString(this.string, s));
                break;
            }
            case 1: {
                Integer i = (Integer)object;
                value.replaceWith(new LdcNumber(i));
                break;
            }
            case 2: {
                Type type = (Type)object;
                assert (section.values.size() == 1);
                this.transformTypeSwitchCase(loop, valueVar, startFromVar, value, section, idx, type, ctx);
                break;
            }
            case 3: {
                Field enumConstant = (Field)object;
                value.replaceWith(new FieldReference(enumConstant));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled type switch type: " + String.valueOf(indyArg));
            }
        }
    }

    @Nullable
    private SwitchTable.SwitchPattern tryCapturePatternVariable(LocalVariable valueVar, Instruction value, SwitchTable.SwitchSection section, @Nullable Type indyArg, StatementTransformContext ctx) {
        Instruction instruction = section.getBody();
        if (!(instruction instanceof Branch)) {
            return null;
        }
        Branch switchBranch = (Branch)instruction;
        Block switchBody = switchBranch.getTargetBlock();
        Instruction instruction2 = switchBody.getFirstChild();
        if (!(instruction2 instanceof Store)) {
            return null;
        }
        Store patternVarStore = (Store)instruction2;
        Instruction unwrappedStoreValue = patternVarStore.getValue();
        if (unwrappedStoreValue instanceof Cast) {
            Cast cast = (Cast)unwrappedStoreValue;
            assert (indyArg != null) : "Expected indyArg to exist for pattern variables with a cast.";
            assert (cast.getType().equals(ctx.getTypeResolver().resolveClass(indyArg)));
            unwrappedStoreValue = cast.getArgument();
        }
        if (LoadStoreMatching.matchLoadLocal(unwrappedStoreValue, valueVar) == null) {
            return null;
        }
        ctx.pushStep("Capture variable into switch section.");
        SwitchTable.SwitchPattern pattern = value.replaceWith(new SwitchTable.SwitchPattern((LocalReference)patternVarStore.getReference()));
        patternVarStore.remove();
        ctx.popStep();
        return pattern;
    }

    private void transformTypeSwitchCase(@Nullable WhileLoop loop, LocalVariable valueVar, LocalVariable startFromVar, Instruction value, SwitchTable.SwitchSection section, int idx, Type indyArg, StatementTransformContext ctx) {
        Branch switchBranch = (Branch)section.getBody();
        Block switchBody = switchBranch.getTargetBlock();
        SwitchTable.SwitchPattern pattern = this.tryCapturePatternVariable(valueVar, value, section, indyArg, ctx);
        if (pattern == null) {
            throw new IllegalStateException("Did not match a pattern variable for a type switch.");
        }
        IfInstruction guardIf = IfMatching.matchNopFalseIf(switchBody.getFirstChild());
        if (guardIf == null) {
            return;
        }
        Instruction instruction = guardIf.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return;
        }
        Block guardBlock = (Block)instruction;
        if (guardBlock.getIncomingEdgeCount() > 1) {
            return;
        }
        Store setStartFromStore = LoadStoreMatching.matchStoreLocal(guardBlock.getFirstChild(), startFromVar);
        if (setStartFromStore == null) {
            return;
        }
        assert (LdcMatching.matchLdcInt(setStartFromStore.getValue(), idx + 1) != null);
        assert (loop != null);
        assert (((Branch)setStartFromStore.getNextSibling()).getTargetBlock() == loop.getBody().getEntryPoint());
        ctx.pushStep("Capture guard condition");
        pattern = pattern.replaceWith(new SwitchTable.SwitchPattern(pattern.getReference(), new LogicNot(guardIf.getCondition())));
        guardIf.remove();
        ExpressionTransforms.runOnExpression(pattern.getCondition(), ctx);
        ctx.popStep();
    }

    @Nullable
    private Switch matchPatternSwitchDecl(@Nullable Instruction insn, LocalVariable valueVar, LocalVariable startFromVar) {
        Switch swtch;
        if (insn instanceof Switch) {
            Switch swtch2 = (Switch)insn;
            if (this.matchTypeSwitchIndy(swtch2.getValue(), valueVar, startFromVar) == null) {
                return null;
            }
            return swtch2;
        }
        Instruction indyCandidate = (Instruction)FastStream.of(valueVar.getReferences()).filter(e -> e.isDescendantOf(insn)).map(e -> LoadStoreMatching.matchLoadLocal(e.getParent(), valueVar)).filter(Objects::nonNull).map(e -> this.matchTypeSwitchIndy(e.getParent(), valueVar, startFromVar)).filter(Objects::nonNull).onlyOrDefault();
        if (indyCandidate == null) {
            return null;
        }
        Instruction instruction = indyCandidate.getParent();
        return instruction instanceof Switch ? (swtch = (Switch)instruction) : null;
    }

    private void cleanupRedundantMatchException(Switch basicSwitch, StatementTransformContext ctx) {
        SwitchTable.SwitchSection firstSection = (SwitchTable.SwitchSection)basicSwitch.getSwitchTable().sections.firstOrDefault();
        if (firstSection == null) {
            return;
        }
        if (!(firstSection.values.onlyOrDefault() instanceof Nop)) {
            return;
        }
        Instruction instruction = firstSection.getBody();
        if (!(instruction instanceof Branch)) {
            return;
        }
        Branch indirect = (Branch)instruction;
        Block block = indirect.getTargetBlock();
        if (block.getIncomingEdgeCount() != 1) {
            return;
        }
        Instruction instruction2 = block.getFirstChild();
        if (!(instruction2 instanceof Throw)) {
            return;
        }
        Throw thrw = (Throw)instruction2;
        New nw = InvokeMatching.matchNew(thrw.getArgument(), Objects.requireNonNull(this.matchException));
        if (nw == null) {
            return;
        }
        if (nw.getArguments().size() != 2) {
            return;
        }
        Iterator iterator = nw.getArguments().iterator();
        while (iterator.hasNext()) {
            Instruction argument = (Instruction)iterator.next();
            if (argument instanceof LdcNull) continue;
            return;
        }
        ctx.pushStep("Remove default MatchException");
        firstSection.remove();
        block.remove();
        ctx.popStep();
    }

    @Nullable
    private InvokeDynamic matchTypeSwitchIndy(Instruction insn, LocalVariable valueVar, LocalVariable startFromVar) {
        InvokeDynamic indy = SwitchOnType.matchTypeSwitchIndy(insn, Objects.requireNonNull(this.switchBootstraps));
        if (indy == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(indy.arguments.get(0), valueVar) == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(indy.arguments.get(1), startFromVar) == null) {
            return null;
        }
        return indy;
    }

    @Nullable
    public static InvokeDynamic matchTypeSwitchIndy(@Nullable Instruction insn, ClassType switchBootstraps) {
        InvokeDynamic indy = InvokeMatching.matchInvokeDynamic(insn, switchBootstraps, "typeSwitch");
        if (indy == null) {
            indy = InvokeMatching.matchInvokeDynamic(insn, switchBootstraps, "enumSwitch");
        }
        if (indy == null) {
            return null;
        }
        if (indy.arguments.size() != 2) {
            return null;
        }
        return indy;
    }
}

