package net.covers1624.coffeegrinder.bytecode;

import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.util.None;
import org.jetbrains.annotations.NotNull;

/**
 * A Visitor capable of visiting {@link Instruction Instructions}.
 * <p>
 * The visitor system is explicitly {@link NotNull}, use {@link None#INSTANCE},
 * for 'none' returns.
 * <p>
 * Created by covers1624 on 16/4/21.
 */
public abstract class InsnVisitor<R, C> {

    public abstract R visitDefault(Instruction insn, C ctx);

    public R visitNop(Nop nop, C ctx) {
        return visitDefault(nop, ctx);
    }

    public R visitDeadCode(DeadCode deadCode, C ctx) {
        return visitDefault(deadCode, ctx);
    }

    public R visitArrayElementReference(ArrayElementReference elemRef, C ctx) {
        return visitDefault(elemRef, ctx);
    }

    public R visitArrayLen(ArrayLen arrayLen, C ctx) {
        return visitDefault(arrayLen, ctx);
    }

    public R visitAssert(Assert assertInsn, C ctx) {
        return visitDefault(assertInsn, ctx);
    }

    public R visitBinary(Binary binary, C ctx) {
        return visitDefault(binary, ctx);
    }

    public R visitBlock(Block block, C ctx) {
        return visitDefault(block, ctx);
    }

    public R visitBlockContainer(BlockContainer container, C ctx) {
        return visitDefault(container, ctx);
    }

    public R visitBranch(Branch branch, C ctx) {
        return visitDefault(branch, ctx);
    }

    public R visitCheckCast(Cast cast, C ctx) {
        return visitDefault(cast, ctx);
    }

    public R visitClassDecl(ClassDecl classDecl, C ctx) {
        return visitDefault(classDecl, ctx);
    }

    public R visitCompare(Compare compare, C ctx) {
        return visitDefault(compare, ctx);
    }

    public R visitComparison(Comparison comparison, C ctx) {
        return visitDefault(comparison, ctx);
    }

    public R visitCompoundAssignment(CompoundAssignment comp, C ctx) {
        return visitDefault(comp, ctx);
    }

    public R visitContinue(Continue cont, C ctx) {
        return visitDefault(cont, ctx);
    }

    public R visitDoWhileLoop(DoWhileLoop doWhileLoop, C ctx) {
        return visitDefault(doWhileLoop, ctx);
    }

    public R visitFieldDecl(FieldDecl fieldDecl, C ctx) {
        return visitDefault(fieldDecl, ctx);
    }

    public R visitFieldReference(FieldReference fieldRef, C ctx) {
        return visitDefault(fieldRef, ctx);
    }

    public R visitForEachLoop(ForEachLoop forEachLoop, C ctx) {
        return visitDefault(forEachLoop, ctx);
    }

    public R visitForLoop(ForLoop forLoop, C ctx) {
        return visitDefault(forLoop, ctx);
    }

    public R visitIfInstruction(IfInstruction ifInsn, C ctx) {
        return visitDefault(ifInsn, ctx);
    }

    public R visitLocalVariable(LocalVariable localVariable, C ctx) {
        return visitDefault(localVariable, ctx);
    }

    public R visitPostIncrement(PostIncrement postIncrement, C ctx) {
        return visitDefault(postIncrement, ctx);
    }

    public R visitInstanceOf(InstanceOf instanceOf, C ctx) {
        return visitDefault(instanceOf, ctx);
    }

    public R visitInvoke(Invoke invoke, C ctx) {
        return visitDefault(invoke, ctx);
    }

    public R visitInvokeDynamic(InvokeDynamic indy, C ctx) {
        return visitDefault(indy, ctx);
    }

    public R visitLdcBoolean(LdcBoolean ldcBoolean, C ctx) {
        return visitDefault(ldcBoolean, ctx);
    }

    public R visitLdcChar(LdcChar ldcChar, C ctx) {
        return visitDefault(ldcChar, ctx);
    }

    public R visitLdcClass(LdcClass ldcClass, C ctx) {
        return visitDefault(ldcClass, ctx);
    }

    public R visitLdcNull(LdcNull ldcNull, C ctx) {
        return visitDefault(ldcNull, ctx);
    }

    public R visitLdcNumber(LdcNumber ldcNumber, C ctx) {
        return visitDefault(ldcNumber, ctx);
    }

    public R visitLdcString(LdcString ldcString, C ctx) {
        return visitDefault(ldcString, ctx);
    }

    public R visitLeave(Leave leave, C ctx) {
        return visitDefault(leave, ctx);
    }

    public R visitLoad(Load load, C ctx) {
        return visitDefault(load, ctx);
    }

    public R visitLoadThis(LoadThis loadThis, C ctx) {
        return visitDefault(loadThis, ctx);
    }

    public R visitLocalReference(LocalReference localRef, C ctx) {
        return visitDefault(localRef, ctx);
    }

    public R visitLogicAnd(LogicAnd logicAnd, C ctx) {
        return visitDefault(logicAnd, ctx);
    }

    public R visitLogicNot(LogicNot logicNot, C ctx) {
        return visitDefault(logicNot, ctx);
    }

    public R visitLogicOr(LogicOr logicOr, C ctx) {
        return visitDefault(logicOr, ctx);
    }

    public R visitMethodDecl(MethodDecl methodDecl, C ctx) {
        return visitDefault(methodDecl, ctx);
    }

    public R visitMethodReference(MethodReference methodReference, C ctx) {
        return visitDefault(methodReference, ctx);
    }

    public R visitMonitorEnter(MonitorEnter monitor, C ctx) {
        return visitDefault(monitor, ctx);
    }

    public R visitMonitorExit(MonitorExit monitor, C ctx) {
        return visitDefault(monitor, ctx);
    }

    public R visitNew(New newInsn, C ctx) {
        return visitDefault(newInsn, ctx);
    }

    public R visitNewArray(NewArray newArray, C ctx) {
        return visitDefault(newArray, ctx);
    }

    public R visitNewObject(NewObject newObject, C ctx) {
        return visitDefault(newObject, ctx);
    }

    public R visitReturn(Return ret, C ctx) {
        return visitDefault(ret, ctx);
    }

    public R visitStore(Store store, C ctx) {
        return visitDefault(store, ctx);
    }

    public R visitSwitch(Switch switchInsn, C ctx) {
        return visitDefault(switchInsn, ctx);
    }

    public R visitSwitchTable(SwitchTable switchTable, C ctx) {
        return visitDefault(switchTable, ctx);
    }

    public R visitSwitchSection(SwitchTable.SwitchSection switchSection, C ctx) {
        return visitDefault(switchSection, ctx);
    }

    public R visitSwitchPattern(SwitchTable.SwitchPattern switchPattern, C ctx) {
        return visitDefault(switchPattern, ctx);
    }

    public R visitSynchronized(Synchronized synchInsn, C ctx) {
        return visitDefault(synchInsn, ctx);
    }

    public R visitTernary(Ternary ternary, C ctx) {
        return visitDefault(ternary, ctx);
    }

    public R visitThrow(Throw throwInsn, C ctx) {
        return visitDefault(throwInsn, ctx);
    }

    public R visitTryCatch(TryCatch tryCatch, C ctx) {
        return visitDefault(tryCatch, ctx);
    }

    public R visitTryCatchHandler(TryCatch.TryCatchHandler catchHandler, C ctx) {
        return visitDefault(catchHandler, ctx);
    }

    public R visitWhileLoop(WhileLoop whileLoop, C ctx) {
        return visitDefault(whileLoop, ctx);
    }

    public R visitYield(Yield yield, C ctx) {
        return visitDefault(yield, ctx);
    }
}
