package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 1/4/21.
 */
public final class ArrayLen extends Instruction {

    private final InstructionSlot<Instruction> array = new InstructionSlot<>(this);

    public ArrayLen(Instruction array) {
        setArray(array);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.INT;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitArrayLen(this, ctx);
    }

    //@formatter:off
    public Instruction getArray() { return array.get(); }
    public void setArray(Instruction array) { this.array.set(array); }
    //@formatter:on
}
