package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;

import java.util.List;

/**
 * Created by covers1624 on 11/8/21.
 */
public class SwitchInlining implements MethodTransformer {

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        List<Switch> switches = function.descendantsToList(Switch.class);

        for (Switch aSwitch : switches) {
            BlockContainer switchContainer = aSwitch.getBody();
            ctx.pushStep("Inline switch sections " + switchContainer.getEntryPoint().getName());

            for (SwitchTable.SwitchSection section : aSwitch.getSwitchTable().sections) {
                if (!(section.getBody() instanceof Branch branch)) continue;

                Block target = branch.getTargetBlock();
                if (target.getIncomingEdgeCount() != 1) continue;

                ctx.pushStep("Inline section");
                branch.replaceWith(target);
                ctx.popStep();

                if (section.getNextSiblingOrNull() instanceof SwitchTable.SwitchSection nextSection
                    && target.instructions.count() > 1
                    && BranchLeaveMatching.compatibleExitInstruction(target.getLastChild(), nextSection.getBody())) {
                    ctx.pushStep("Create fallthrough");
                    target.getLastChild().remove();
                    ctx.popStep();
                    continue;
                }

                ConditionDetection.tryUnwrap(target, ctx);
            }

            ctx.popStep();
        }
    }
}
