/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.accessors;

import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.accessors.SyntheticAccessor;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AccessorParser {
    private static final int[] PRE_POST_CONST = new int[]{4, 4, 4, 4, 12, 10, 15};
    private static final int[] PRE_POST_CAST = new int[]{146, 145, 147, -1, -1, -1, -1};
    private static final List<AccessorMatcher> FUNCS = List.of(AccessorParser::matchFieldLoadAccessor, AccessorParser::matchFieldSetAccessor, AccessorParser::matchMethodAccessor, AccessorParser::matchCtorAccessor, AccessorParser::matchFieldPrePostIncrementAccessor);

    @Nullable
    public static SyntheticAccessor parseAccessor(TypeResolver resolver, MethodNode mNode) {
        for (AccessorMatcher matcher : FUNCS) {
            try {
                return matcher.match(resolver, mNode, new InsnCursor(mNode.instructions));
            }
            catch (MatchFailed matchFailed) {
            }
        }
        return null;
    }

    private static SyntheticAccessor.FieldAccessor matchFieldLoadAccessor(TypeResolver resolver, MethodNode mNode, InsnCursor c) {
        FieldInsnNode field;
        Type mDesc = Type.getMethodType((String)mNode.desc);
        Type retType = mDesc.getReturnType();
        if (c.peekVarInsn(25, 0)) {
            c.requireVarInsn(25, 0);
            field = c.requireFieldInsn(180);
        } else {
            field = c.requireFieldInsn(178);
        }
        c.requireInsn(retType.getOpcode(172));
        return new SyntheticAccessor.FieldAccessor(SyntheticAccessor.AccessorType.FIELD_LOAD, resolver.resolveClassDecl(field.owner).resolveField(field.name, Type.getType((String)field.desc)));
    }

    private static SyntheticAccessor.FieldAccessor matchFieldSetAccessor(TypeResolver resolver, MethodNode mNode, InsnCursor c) {
        FieldInsnNode field;
        if (mNode.name.equals("<init>")) {
            throw MatchFailed.INSTANCE;
        }
        Type mDesc = Type.getMethodType((String)mNode.desc);
        Type[] args = mDesc.getArgumentTypes();
        Type retType = mDesc.getReturnType();
        if (args.length == 2) {
            if (!args[1].equals((Object)retType)) {
                throw MatchFailed.INSTANCE;
            }
            c.requireVarInsn(25, 0);
            c.requireVarInsn(retType.getOpcode(21), 1);
            c.requireInsn(retType.getSize() == 1 ? 90 : 93);
            field = c.requireFieldInsn(181);
        } else {
            if (args.length != 1 || !args[0].equals((Object)retType)) {
                throw MatchFailed.INSTANCE;
            }
            c.requireVarInsn(retType.getOpcode(21), 0);
            c.requireInsn(retType.getSize() == 1 ? 89 : 92);
            field = c.requireFieldInsn(179);
        }
        c.requireInsn(retType.getOpcode(172));
        return new SyntheticAccessor.FieldAccessor(SyntheticAccessor.AccessorType.FIELD_STORE, resolver.resolveClassDecl(field.owner).resolveField(field.name, Type.getType((String)field.desc)));
    }

    private static SyntheticAccessor matchFieldPrePostIncrementAccessor(TypeResolver resolver, MethodNode mNode, InsnCursor c) {
        int putOpcode;
        int dupOpcode;
        FieldInsnNode field;
        boolean isStatic;
        Type mDesc = Type.getMethodType((String)mNode.desc);
        Type retType = mDesc.getReturnType();
        boolean bl = isStatic = !c.peekVarInsn(25, 0);
        if (!isStatic) {
            c.requireVarInsn(25, 0);
            c.requireInsn(89);
            field = c.requireFieldInsn(180);
            if (!field.desc.equals(retType.toString())) {
                throw MatchFailed.INSTANCE;
            }
            dupOpcode = retType.getSize() == 1 ? 90 : 93;
            putOpcode = 181;
        } else {
            field = c.requireFieldInsn(178);
            if (!field.desc.equals(retType.toString())) {
                throw MatchFailed.INSTANCE;
            }
            dupOpcode = retType.getSize() == 1 ? 89 : 92;
            putOpcode = 179;
        }
        boolean postInc = c.peekInsn(dupOpcode);
        if (postInc) {
            c.requireInsn(dupOpcode);
        }
        c.requireInsn(PRE_POST_CONST[retType.getSort() - 2]);
        boolean positive = c.peekInsn(retType.getOpcode(96));
        c.requireInsn(retType.getOpcode(positive ? 96 : 100));
        int castOpcode = PRE_POST_CAST[retType.getSort() - 2];
        if (castOpcode != -1) {
            c.requireInsn(castOpcode);
        }
        if (!postInc) {
            c.requireInsn(dupOpcode);
        }
        c.requireFieldInsn(putOpcode, field);
        c.requireInsn(retType.getOpcode(172));
        Field fieldType = resolver.resolveClassDecl(field.owner).resolveField(field.name, retType);
        if (postInc) {
            return new SyntheticAccessor.FieldIncrementAccessor(SyntheticAccessor.AccessorType.FIELD_POST_INC, fieldType, positive);
        }
        return new SyntheticAccessor.FieldIncrementAccessor(SyntheticAccessor.AccessorType.FIELD_PRE_INC, fieldType, positive);
    }

    private static SyntheticAccessor.MethodAccessor matchMethodAccessor(TypeResolver resolver, MethodNode mNode, InsnCursor c) {
        MethodInsnNode method;
        if (mNode.name.equals("<init>")) {
            throw MatchFailed.INSTANCE;
        }
        Type mDesc = Type.getMethodType((String)mNode.desc);
        Type[] args = mDesc.getArgumentTypes();
        Type retType = mDesc.getReturnType();
        int index = 0;
        for (Type type : args) {
            c.requireVarInsn(type.getOpcode(21), index);
            index += type.getSize();
        }
        if (c.peekMethodInsn(184)) {
            method = c.requireMethodInsn(184);
        } else if (c.peekMethodInsn(182)) {
            method = c.requireMethodInsn(182);
        } else {
            method = c.requireMethodInsn(183);
            if (method.name.equals("<init>")) {
                throw MatchFailed.INSTANCE;
            }
        }
        c.requireInsn(retType.getOpcode(172));
        return new SyntheticAccessor.MethodAccessor(SyntheticAccessor.AccessorType.INVOKE, resolver.resolveClassDecl(method.owner).resolveMethod(method.name, Type.getMethodType((String)method.desc)));
    }

    private static SyntheticAccessor.CtorAccessor matchCtorAccessor(TypeResolver resolver, MethodNode mNode, InsnCursor c) {
        if (!mNode.name.equals("<init>")) {
            throw MatchFailed.INSTANCE;
        }
        Type mDesc = Type.getMethodType((String)mNode.desc);
        Type[] args = mDesc.getArgumentTypes();
        if (args.length < 1) {
            throw MatchFailed.INSTANCE;
        }
        c.requireVarInsn(25, 0);
        int index = 1;
        for (int i = 0; i < args.length - 1; ++i) {
            Type type = args[i];
            c.requireVarInsn(type.getOpcode(21), index);
            index += type.getSize();
        }
        MethodInsnNode method = c.requireMethodInsn(183, "<init>");
        c.requireInsn(177);
        return new SyntheticAccessor.CtorAccessor(resolver.resolveClassDecl(method.owner).resolveMethod(method.name, Type.getMethodType((String)method.desc)), resolver.resolveClassDecl(args[args.length - 1]));
    }

    public static interface AccessorMatcher {
        public SyntheticAccessor match(TypeResolver var1, MethodNode var2, InsnCursor var3) throws MatchFailed;
    }

    public static class InsnCursor {
        @Nullable
        private AbstractInsnNode pointer;

        public InsnCursor(InsnList list) {
            this.pointer = InsnCursor.skipUnimportant(list.getFirst());
        }

        public void requireInsn(int opcode) {
            if (!this.peekInsn(opcode)) {
                throw MatchFailed.INSTANCE;
            }
            this.move();
        }

        public void requireVarInsn(int opcode, int operand) {
            if (!this.peekVarInsn(opcode, operand)) {
                throw MatchFailed.INSTANCE;
            }
            this.move();
        }

        public FieldInsnNode requireFieldInsn(int opcode) {
            return this.requireFieldInsn(opcode, null);
        }

        public FieldInsnNode requireFieldInsn(int opcode, @Nullable FieldInsnNode other) {
            if (!this.peekFieldInsn(opcode, other)) {
                throw MatchFailed.INSTANCE;
            }
            return (FieldInsnNode)this.move();
        }

        public MethodInsnNode requireMethodInsn(int opcode) {
            return this.requireMethodInsn(opcode, "*");
        }

        public MethodInsnNode requireMethodInsn(int opcode, String name) {
            if (!this.peekMethodInsn(opcode, name)) {
                throw MatchFailed.INSTANCE;
            }
            return (MethodInsnNode)this.move();
        }

        public boolean peekInsn(int opcode) {
            AbstractInsnNode insn = this.peek();
            return insn.getOpcode() == opcode;
        }

        public boolean peekVarInsn(int opcode, int operand) {
            AbstractInsnNode insn = this.peek();
            if (insn.getOpcode() != opcode) {
                return false;
            }
            return ((VarInsnNode)insn).var == operand;
        }

        public boolean peekFieldInsn(int opcode) {
            return this.peekFieldInsn(opcode, null);
        }

        public boolean peekFieldInsn(int opcode, @Nullable FieldInsnNode other) {
            AbstractInsnNode insn = this.peek();
            if (insn.getOpcode() != opcode) {
                return false;
            }
            FieldInsnNode fInsn = (FieldInsnNode)insn;
            if (other == null) {
                return true;
            }
            return other.owner.equals(fInsn.owner) && other.name.equals(fInsn.name) && other.desc.equals(fInsn.desc);
        }

        public boolean peekMethodInsn(int opcode) {
            return this.peekMethodInsn(opcode, "*");
        }

        public boolean peekMethodInsn(int opcode, String name) {
            AbstractInsnNode insn = this.peek();
            if (insn.getOpcode() != opcode) {
                return false;
            }
            MethodInsnNode mInsn = (MethodInsnNode)insn;
            return name.equals("*") || name.equals(mInsn.name);
        }

        public AbstractInsnNode peek() {
            return Objects.requireNonNull(this.pointer, "Already read entire method.");
        }

        public AbstractInsnNode move() {
            AbstractInsnNode curr = this.peek();
            this.pointer = InsnCursor.skipUnimportant(this.peek().getNext());
            return curr;
        }

        @Nullable
        private static AbstractInsnNode skipUnimportant(AbstractInsnNode pointer) {
            while (pointer != null && (pointer.getType() == 8 || pointer.getType() == 15 || pointer.getType() == 14)) {
                pointer = pointer.getNext();
            }
            return pointer;
        }
    }

    private static class MatchFailed
    extends RuntimeException {
        private static final MatchFailed INSTANCE = new MatchFailed();

        private MatchFailed() {
        }

        static {
            INSTANCE.setStackTrace(new StackTraceElement[0]);
        }
    }
}

