/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.IntegerConstantInference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Binary
extends Instruction {
    private BinaryOp op;
    private final InstructionSlot<Instruction> left = new InstructionSlot(this);
    private final InstructionSlot<Instruction> right = new InstructionSlot(this);

    public Binary(BinaryOp op, Instruction left, Instruction right) {
        this.op = op;
        this.left.set(left);
        this.right.set(right);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        AType lh = this.left.get().getResultType();
        boolean doesThrow = !(lh != PrimitiveType.INT && lh != PrimitiveType.LONG || this.op != BinaryOp.DIV && this.op != BinaryOp.REM);
        return doesThrow ? InstructionFlag.MAY_THROW.toSet() : InstructionFlag.NONE;
    }

    @Override
    public AType getResultType() {
        AType leftType = this.left.get().getResultType();
        AType rightType = this.right.get().getResultType();
        if (TypeSystem.isString(leftType)) {
            return leftType;
        }
        if (TypeSystem.isString(rightType)) {
            return rightType;
        }
        if (leftType.equals(PrimitiveType.BOOLEAN) || rightType.equals(PrimitiveType.BOOLEAN)) {
            return PrimitiveType.BOOLEAN;
        }
        if (this.op.isLogic() && IntegerConstantInference.isBooleanConstant(leftType) && IntegerConstantInference.isBooleanConstant(rightType)) {
            return IntegerConstantInference.BOOLEAN_CONSTANTS;
        }
        if (TypeSystem.isAssignableTo(leftType, PrimitiveType.INT) && TypeSystem.isAssignableTo(rightType, PrimitiveType.INT)) {
            return PrimitiveType.INT;
        }
        if (TypeSystem.isAssignableTo(leftType, PrimitiveType.LONG) && TypeSystem.isAssignableTo(rightType, PrimitiveType.LONG)) {
            return PrimitiveType.LONG;
        }
        if (TypeSystem.isAssignableTo(leftType, PrimitiveType.FLOAT) && TypeSystem.isAssignableTo(rightType, PrimitiveType.FLOAT)) {
            return PrimitiveType.FLOAT;
        }
        if (TypeSystem.isAssignableTo(leftType, PrimitiveType.DOUBLE) && TypeSystem.isAssignableTo(rightType, PrimitiveType.DOUBLE)) {
            return PrimitiveType.DOUBLE;
        }
        throw new IllegalStateException("Conflicting types for NumericInsn." + String.valueOf((Object)this.op) + " (" + String.valueOf(leftType) + ", " + String.valueOf(rightType) + ")");
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitBinary(this, ctx);
    }

    public BinaryOp getOp() {
        return this.op;
    }

    public Instruction getLeft() {
        return this.left.get();
    }

    public Instruction getRight() {
        return this.right.get();
    }

    public void setOp(BinaryOp op) {
        this.op = op;
        this.invalidateFlags();
    }

    public void setLeft(Instruction left) {
        this.left.set(left);
    }

    public void setRight(Instruction right) {
        this.right.set(right);
    }
}

