/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.lang.reflect.AccessFlag;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.tags.InsnTag;
import net.covers1624.coffeegrinder.source.AstSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.Copyable;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Instruction
implements Copyable<Instruction> {
    private int refCount;
    @Nullable
    private EnumBitSet<InstructionFlag> flags = InstructionFlag.INVALID_FLAGS;
    @Nullable
    InstructionSlot<?> inSlot;
    @Nullable
    InstructionSlot<?> firstChild;
    @Nullable
    InstructionSlot<?> lastChild;
    @Nullable
    private InsnTag tag;
    private int bytecodeOffset = -1;
    private int sourceLine = -1;

    protected Instruction() {
    }

    public abstract AType getResultType();

    public Instruction copy() {
        throw new UnsupportedOperationException("Instruction '" + this.getClass().getName() + "' does not support being copied.");
    }

    public abstract EnumBitSet<InstructionFlag> getDirectFlags();

    public final EnumBitSet<InstructionFlag> getFlags() {
        if (this.flags == InstructionFlag.INVALID_FLAGS) {
            this.flags = this.computeFlags();
        }
        return this.flags;
    }

    public final boolean hasFlag(InstructionFlag flag) {
        return this.getFlags().get(flag);
    }

    public final boolean hasDirectFlag(InstructionFlag flag) {
        return this.getDirectFlags().get(flag);
    }

    public abstract <R, C> R accept(InsnVisitor<R, C> var1, C var2);

    public final <R> R accept(InsnVisitor<R, None> visitor) {
        return this.accept(visitor, None.INSTANCE);
    }

    @Nullable
    public final Instruction getParentOrNull() {
        return this.inSlot != null ? this.inSlot.parent : null;
    }

    public final Instruction getParent() {
        return Objects.requireNonNull(this.getParentOrNull());
    }

    @Nullable
    public final Instruction getNextSiblingOrNull() {
        if (this.inSlot == null || this.inSlot.nextSibling == null) {
            return null;
        }
        InstructionSlot<?> slot = this.inSlot.nextSibling.onNext();
        return slot == null ? null : (Instruction)slot.getValueOrNull();
    }

    public final Instruction getNextSibling() {
        return Objects.requireNonNull(this.getNextSiblingOrNull());
    }

    @Nullable
    public final Instruction getPrevSiblingOrNull() {
        if (this.inSlot == null || this.inSlot.prevSibling == null) {
            return null;
        }
        InstructionSlot<?> slot = this.inSlot.prevSibling.onPrevious(this.inSlot);
        return slot == null ? null : (Instruction)slot.getValueOrNull();
    }

    public final Instruction getPrevSibling() {
        return Objects.requireNonNull(this.getPrevSiblingOrNull());
    }

    @Nullable
    public final Instruction getFirstChildOrNull() {
        if (this.firstChild == null) {
            return null;
        }
        InstructionSlot<?> slot = this.firstChild.onNext();
        return slot == null ? null : (Instruction)slot.getValueOrNull();
    }

    public final Instruction getFirstChild() {
        return Objects.requireNonNull(this.getFirstChildOrNull());
    }

    @Nullable
    public final Instruction getLastChildOrNull() {
        if (this.lastChild == null) {
            return null;
        }
        InstructionSlot<?> slot = this.lastChild.onPrevious(this.inSlot);
        return slot == null ? null : (Instruction)slot.getValueOrNull();
    }

    public final Instruction getLastChild() {
        return Objects.requireNonNull(this.getLastChildOrNull());
    }

    public final FastStream<Instruction> getChildren() {
        InstructionSlot<?> firstChild = this.firstChild;
        if (firstChild == null) {
            return FastStream.empty();
        }
        return new FastStream<Instruction>(){

            public Iterator<Instruction> iterator() {
                return new Iterator<Instruction>(){
                    @Nullable
                    Instruction next;
                    {
                        this.next = Instruction.this.getFirstChildOrNull();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Instruction next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Instruction value = this.next;
                        this.next = this.next.getNextSiblingOrNull();
                        return value;
                    }
                };
            }

            public void forEach(Consumer<? super Instruction> action) {
                for (Instruction next = Instruction.this.getFirstChildOrNull(); next != null; next = next.getNextSiblingOrNull()) {
                    Instruction value = next;
                    action.accept(value);
                }
            }
        };
    }

    public final FastStream<Instruction> getDescendants() {
        Instruction firstChild = this.getFirstChildOrNull();
        if (firstChild == null) {
            return FastStream.of((Object)this);
        }
        return new FastStream<Instruction>(){

            public Iterator<Instruction> iterator() {
                return new Iterator<Instruction>(){
                    @Nullable
                    private Instruction next;
                    {
                        this.next = this.deepestChild(Instruction.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Instruction next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Instruction ret = this.next;
                        this.next = this.nextInsn(this.next);
                        return ret;
                    }

                    private Instruction deepestChild(Instruction insn) {
                        Instruction child;
                        while ((child = insn.getFirstChildOrNull()) != null) {
                            insn = child;
                        }
                        return insn;
                    }

                    @Nullable
                    private Instruction nextInsn(Instruction insn) {
                        if (insn == Instruction.this) {
                            return null;
                        }
                        Instruction next = insn.getNextSiblingOrNull();
                        if (next != null) {
                            return this.deepestChild(next);
                        }
                        return insn.getParent();
                    }
                };
            }

            public void forEach(Consumer<? super Instruction> action) {
                Instruction.this.forEachDescendent(action);
            }
        };
    }

    private void forEachDescendent(Consumer<? super Instruction> action) {
        for (Instruction next = this.getFirstChildOrNull(); next != null; next = next.getNextSiblingOrNull()) {
            Instruction value = next;
            value.forEachDescendent(action);
        }
        action.accept(this);
    }

    public final <R extends Instruction> FastStream<R> descendantsOfType(Class<? extends R> type) {
        assert (type.accessFlags().contains((Object)AccessFlag.FINAL));
        return (FastStream)SneakyUtils.unsafeCast((Object)this.getDescendants().filter(e -> e.getClass() == type));
    }

    public final <R extends Instruction> FastStream<R> descendantsWhere(Predicate<Instruction> filter) {
        return (FastStream)SneakyUtils.unsafeCast((Object)this.getDescendants().filter(filter));
    }

    public final <R extends Instruction> FastStream<R> descendantsMatching(Function<Instruction, @Nullable R> filter) {
        return this.getDescendants().map(filter).filter(Objects::nonNull);
    }

    public final <R extends Instruction> LinkedList<R> descendantsToList(Class<? extends R> type) {
        return this.descendantsOfType(type).toLinkedList();
    }

    public final <R extends Instruction> LinkedList<R> descendantsToListWhere(Predicate<Instruction> filter) {
        return this.descendantsWhere(filter).toLinkedList();
    }

    public final <R extends Instruction> R firstAncestorOfType(Class<? extends R> type) {
        assert (type.accessFlags().contains((Object)AccessFlag.FINAL));
        Instruction insn = this;
        while (insn.getClass() != type) {
            insn = insn.getParent();
        }
        return (R)insn;
    }

    public final <R extends Instruction> FastStream<R> ancestorsOfType(final Class<? extends R> type) {
        return new FastStream<R>(){

            @NotNull
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    @Nullable
                    private R next;
                    {
                        this.next = this.firstAncestorOfTypeOrDefault(Instruction.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public R next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object insn = this.next;
                        this.next = this.firstAncestorOfTypeOrDefault(((Instruction)insn).getParentOrNull());
                        return insn;
                    }

                    @Nullable
                    private R firstAncestorOfTypeOrDefault(@Nullable Instruction insn) {
                        while (insn != null && insn.getClass() != type) {
                            insn = insn.getParentOrNull();
                        }
                        return insn;
                    }
                };
            }

            public void forEach(Consumer<? super R> action) {
                for (Instruction insn = Instruction.this; insn != null; insn = insn.getParentOrNull()) {
                    if (insn.getClass() != type) continue;
                    action.accept(insn);
                }
            }
        };
    }

    public final boolean isDescendantOf(@Nullable Instruction possibleAncestor) {
        if (possibleAncestor == null) {
            return false;
        }
        for (Instruction candidate = this; candidate != null; candidate = candidate.getParentOrNull()) {
            if (candidate != possibleAncestor) continue;
            return true;
        }
        return false;
    }

    public final void addRef() {
        if (this.refCount == -1) {
            throw new IllegalStateException("Attempted to revive dead instruction.");
        }
        if (this.refCount++ == 0) {
            this.onConnected();
        }
    }

    public final void releaseRef() {
        assert (this.refCount > 0);
        if (--this.refCount == 0) {
            this.refCount = -1;
            this.inSlot = null;
            this.onDisconnected();
        }
    }

    public final boolean isConnected() {
        return this.refCount > 0;
    }

    public final void remove() {
        assert (this.inSlot != null);
        if (!this.inSlot.isInCollection()) {
            throw new UnsupportedOperationException("Instruction is not inside a collection.");
        }
        this.inSlot.remove();
        this.inSlot = null;
    }

    public final void insertBefore(Instruction value) {
        if (this.inSlot != null) {
            this.inSlot.insertBefore(value);
        }
    }

    public final void insertAfter(Instruction value) {
        if (this.inSlot != null) {
            this.inSlot.insertAfter(value);
        }
    }

    public final <T extends Instruction> T replaceWith(T value) {
        if (value == this) {
            return value;
        }
        assert (this.inSlot != null);
        this.inSlot.set(value);
        return value;
    }

    @Nullable
    public final InsnTag getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable InsnTag tag) {
        if (this.tag != null && tag != null) {
            throw new IllegalStateException("Can't replace tag.");
        }
        this.tag = tag;
    }

    public final <T extends Instruction> T withTag(@Nullable InsnTag tag) {
        this.setTag(tag);
        return (T)((Instruction)SneakyUtils.unsafeCast((Object)this));
    }

    public final int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public final void setBytecodeOffset(int bytecodeOffset) {
        this.bytecodeOffset = bytecodeOffset;
    }

    public final <T extends Instruction> T withOffsets(Instruction sourceInsn) {
        this.setOffsets(sourceInsn);
        return (T)((Instruction)SneakyUtils.unsafeCast((Object)this));
    }

    public final void setOffsets(Instruction sourceInsn) {
        this.setBytecodeOffset(sourceInsn.getBytecodeOffset());
        this.setSourceLine(sourceInsn.getSourceLine());
    }

    public final int getSourceLine() {
        return this.sourceLine;
    }

    public final void setSourceLine(int sourceLine) {
        this.sourceLine = sourceLine;
    }

    public String toString() {
        return this.toString(DebugPrintOptions.DEFAULT);
    }

    public String toString(DebugPrintOptions opts) {
        AstSourceVisitor visitor = new AstSourceVisitor(opts);
        LineBuffer ast = this.accept(visitor);
        Instruction last = this;
        while (last.getParentOrNull() != null) {
            last = last.getParentOrNull();
        }
        return ast.toString();
    }

    protected void invalidateFlags() {
        for (Instruction insn = this; insn != null && insn.flags != InstructionFlag.INVALID_FLAGS; insn = insn.getParentOrNull()) {
            insn.flags = InstructionFlag.INVALID_FLAGS;
        }
    }

    @MustBeInvokedByOverriders
    protected void onConnected() {
        InstructionSlot<?> slot = this.firstChild;
        while (slot != null) {
            slot.onConnected();
            slot = slot.nextSibling;
        }
    }

    @MustBeInvokedByOverriders
    protected void onDisconnected() {
        InstructionSlot<?> next = this.firstChild;
        while (next != null && (next = next.onNext()) != null) {
            Instruction value = next.value;
            if (value != null) {
                value.releaseRef();
            }
            next = next.nextSibling;
        }
    }

    protected void onChildModified() {
    }

    protected EnumBitSet<InstructionFlag> computeFlags() {
        Object flags = this.getDirectFlags().clone();
        this.getChildren().forEach(arg_0 -> Instruction.lambda$computeFlags$2((EnumBitSet)flags, arg_0));
        return flags;
    }

    private static /* synthetic */ void lambda$computeFlags$2(EnumBitSet flags, Instruction e) {
        flags.or(e.getFlags());
    }

    private static /* synthetic */ String lambda$toString$1(String e) {
        return "import " + e;
    }
}

