/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.TransformerUtils;
import net.covers1624.quack.collection.FastStream;

public class SwitchDetection
implements BlockTransformer {
    private BlockTransformContext ctx;

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        this.ctx = ctx;
        Instruction last = (Instruction)block.instructions.lastOrDefault();
        if (last instanceof SwitchTable) {
            this.transformSwitch(block, (SwitchTable)last);
        }
    }

    private void transformSwitch(Block block, SwitchTable switchTable) {
        ControlFlowNode entryPoint = this.ctx.getControlFlowNode();
        LinkedList<Block> blocks = this.getSwitchBlocks(entryPoint);
        BlockContainer switchContainer = new BlockContainer();
        Block newEntryPoint = (Block)new Block(block.getSubName("switch")).withOffsets(switchTable);
        newEntryPoint.instructions.add(switchTable);
        blocks.addFirst(newEntryPoint);
        block.instructions.add((Instruction)new Switch(switchTable.getValue(), switchContainer).withOffsets(switchTable));
        switchTable.setValue(new Nop());
        TransformerUtils.moveBlocksIntoContainer(blocks, (BlockContainer)block.getParent(), switchContainer, null);
    }

    private LinkedList<Block> getSwitchBlocks(ControlFlowNode entryPoint) {
        List<ControlFlowNode> cases = entryPoint.getSuccessors();
        ControlFlowNode lastCase = cases.getLast();
        ControlFlowNode exitNode = lastCase.getPredecessors().size() > 1 ? lastCase : null;
        return FastStream.of(cases).filter(c -> c != exitNode).flatMap(this::getCaseContents).map(e -> e.block).toLinkedList();
    }

    private FastStream<ControlFlowNode> getCaseContents(ControlFlowNode caseNode) {
        LinkedList<ControlFlowNode> nodes = new LinkedList<ControlFlowNode>();
        ControlFlowNode[] cfg = this.ctx.getControlFlowGraph().cfg;
        for (int i = caseNode.cfgIndex; i < cfg.length && caseNode.dominates(cfg[i]); ++i) {
            nodes.add(cfg[i]);
        }
        return FastStream.of(nodes);
    }
}

