/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

import java.util.List;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.source.EscapeUtils;
import net.covers1624.coffeegrinder.source.ImportCollector;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public abstract class AbstractSourceVisitor
extends InsnVisitor<LineBuffer, None> {
    protected static final String INDENT = "    ";
    protected final ImportCollector importCollector;
    protected int indent;

    protected AbstractSourceVisitor(@Nullable TypeResolver typeResolver) {
        this.importCollector = new ImportCollector(typeResolver);
    }

    protected final void pushIndent() {
        ++this.indent;
    }

    protected final void popIndent() {
        --this.indent;
    }

    protected LineBuffer lines(Instruction other) {
        return other.accept(this);
    }

    protected final LineBuffer indent(LineBuffer buffer) {
        return LineBuffer.of((List<String>)FastStream.of(buffer.lines).map(this::indent).toImmutableList());
    }

    protected final String indent(String line) {
        if (line.isEmpty()) {
            return line;
        }
        if (line.startsWith(" ")) {
            return line;
        }
        return INDENT.repeat(this.indent) + line;
    }

    protected boolean showImplicits() {
        return false;
    }

    protected final LineBuffer argList(Instruction ... args) {
        return this.argList((FastStream<Instruction>)FastStream.of((Object[])args));
    }

    protected final LineBuffer argList(FastStream<Instruction> args) {
        return this.argList("(", args, ")");
    }

    protected final LineBuffer argList(String prefix, FastStream<Instruction> args, String suffix) {
        LineBuffer buffer = LineBuffer.of(prefix);
        boolean first = true;
        for (Instruction argument : args) {
            if (argument instanceof Nop && !this.showImplicits()) continue;
            if (!first) {
                buffer = buffer.append(", ");
            }
            first = false;
            buffer = buffer.append(this.lines(argument));
        }
        return buffer.append(suffix);
    }

    protected final String typeParameters(ITypeParameterizedMember member, AnnotationSupplier annotationSupplier) {
        List<TypeParameter> typeParameters = member.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameter param = typeParameters.get(i);
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.importCollector.collectTypeParam(param, annotationSupplier));
        }
        builder.append(">");
        return builder.toString();
    }

    protected final LineBuffer appendTypeArguments(List<ReferenceType> args, LineBuffer buffer) {
        if (args.isEmpty()) {
            return buffer;
        }
        buffer = buffer.append("<");
        boolean first = true;
        for (ReferenceType typeArgument : args) {
            if (!first) {
                buffer = buffer.append(", ");
            }
            first = false;
            buffer = buffer.append(this.importCollector.collect(typeArgument));
        }
        buffer = buffer.append(">");
        return buffer;
    }

    protected final LineBuffer debugIndyBSMArg(Object obj) {
        if (obj instanceof Method) {
            Method meth = (Method)obj;
            return LineBuffer.of("METHOD ").append(this.importCollector.collect(meth.getDeclaringClass())).append(".").append(meth.getName());
        }
        if (obj instanceof Field) {
            Field field = (Field)obj;
            return LineBuffer.of("FIELD ").append(this.importCollector.collect(field.getDeclaringClass())).append(".").append(field.getName());
        }
        if (obj instanceof String || obj instanceof Type) {
            return LineBuffer.of("\"").append(EscapeUtils.escapeChars(obj.toString())).append("\"");
        }
        return LineBuffer.of(obj);
    }
}

